/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.customslots.IExtensionSlot;
import dev.gigaherz.toolbelt.network.BeltContentsChange;
import dev.gigaherz.toolbelt.slot.BeltExtensionSlot;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.network.PacketDistributor;

public class BeltFinderBeltSlot
extends BeltFinder {
    public static final String FINDER_ID = "belt_slot";
    public static Capability<BeltExtensionSlot> BELT_EXTENSION_SLOT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<BeltExtensionSlot>(){});

    public static void initBaubles() {
        BeltFinder.addFinder(new BeltFinderBeltSlot());
    }

    @Override
    protected Optional<BeltFinder.BeltGetter> getSlotFromId(Player player, int slotId) {
        return BeltExtensionSlot.get((LivingEntity)player).resolve().map(BeltExtensionSlot::getSlots).map(slots -> (IExtensionSlot)slots.get(slotId)).map(slot -> new ExtensionSlotBeltGetter((LivingEntity)player, (IExtensionSlot)slot));
    }

    @Override
    public String getName() {
        return FINDER_ID;
    }

    @Override
    public Optional<? extends BeltFinder.BeltGetter> findStack(LivingEntity player, boolean allowCosmetic) {
        return BeltExtensionSlot.get(player).resolve().flatMap(ext -> ext.getSlots().stream().filter(slot -> slot.getContents().m_41720_() instanceof ToolBeltItem).map(slot -> new ExtensionSlotBeltGetter(player, (IExtensionSlot)slot)).findFirst());
    }

    private static class ExtensionSlotBeltGetter
    implements BeltFinder.BeltGetter {
        private final LivingEntity player;
        private final IExtensionSlot slot;

        private ExtensionSlotBeltGetter(LivingEntity player, IExtensionSlot slot) {
            this.player = player;
            this.slot = slot;
        }

        @Override
        public ItemStack getBelt() {
            return this.slot.getContents();
        }

        @Override
        public void setBelt(ItemStack stack) {
            this.slot.setContents(stack);
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public void syncToClients() {
            LivingEntity thePlayer = this.slot.getContainer().getOwner();
            if (thePlayer.f_19853_.f_46443_) {
                return;
            }
            BeltContentsChange message = new BeltContentsChange(thePlayer, BeltFinderBeltSlot.FINDER_ID, 0, this.slot.getContents());
            ToolBelt.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> thePlayer), (Object)message);
        }
    }
}

