/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.network;

import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkEvent;

public class SwapItems {
    public int swapWith;

    public SwapItems(int windowId) {
        this.swapWith = windowId;
    }

    public SwapItems(FriendlyByteBuf buf) {
        this.swapWith = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.swapWith);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SwapItems.swapItem(this.swapWith, (Player)((NetworkEvent.Context)context.get()).getSender()));
        return true;
    }

    public static void swapItem(int swapWith, Player player) {
        BeltFinder.findBelt((LivingEntity)player).ifPresent(getter -> {
            ItemStack stack = getter.getBelt();
            if (stack.m_41613_() <= 0) {
                return;
            }
            ItemStack inHand = player.m_21205_();
            if (!ConfigData.isItemStackAllowed(inHand)) {
                return;
            }
            IItemHandlerModifiable cap = (IItemHandlerModifiable)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(() -> new RuntimeException("No inventory!"));
            if (swapWith < 0) {
                player.m_21008_(InteractionHand.MAIN_HAND, ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)inHand, (boolean)false));
            } else {
                ItemStack inSlot = cap.getStackInSlot(swapWith);
                player.m_21008_(InteractionHand.MAIN_HAND, inSlot);
                cap.setStackInSlot(swapWith, inHand);
            }
            getter.syncToClients();
        });
    }
}

