/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.slot;

import com.google.common.collect.ImmutableList;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.customslots.ExtensionSlotItemHandler;
import dev.gigaherz.toolbelt.customslots.IExtensionContainer;
import dev.gigaherz.toolbelt.customslots.IExtensionSlot;
import dev.gigaherz.toolbelt.network.SyncBeltSlotContents;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BeltExtensionSlot
implements IExtensionContainer,
INBTSerializable<CompoundTag> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean ENABLE_DEBUG_LOGGING = "true".equals(System.getProperty("toolbelt.debug", FMLEnvironment.production ? "false" : "true"));
    private static final ResourceLocation CAPABILITY_ID = new ResourceLocation("toolbelt", "belt_slot");
    public static Capability<BeltExtensionSlot> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<BeltExtensionSlot>(){});
    public static final ResourceLocation BELT = new ResourceLocation("examplemod", "belt");
    private final LivingEntity owner;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BeltExtensionSlot.this.belt.onContentsChanged();
        }
    };
    private final ExtensionSlotItemHandler belt = new ExtensionSlotItemHandler(this, BELT, (IItemHandlerModifiable)this.inventory, 0);
    private final ImmutableList<IExtensionSlot> slots = ImmutableList.of((Object)this.belt);

    private static void printDebugLog(String message, Object ... params) {
        if (ENABLE_DEBUG_LOGGING) {
            LOGGER.info(message, params);
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new AttachHandlers());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
    }

    public static LazyOptional<BeltExtensionSlot> get(LivingEntity player) {
        return player.getCapability(CAPABILITY);
    }

    private void dropContents() {
        for (IExtensionSlot slot : this.slots) {
            ItemStack stack = slot.getContents();
            if (stack.m_41613_() <= 0) continue;
            BeltExtensionSlot.printDebugLog("Player {}({}) has item in the belt slot, but the belt is disabled. Dropping to the ground.", this.owner.m_6302_(), this.owner.m_20148_());
            if (this.owner instanceof Player) {
                ItemHandlerHelper.giveItemToPlayer((Player)((Player)this.owner), (ItemStack)stack);
            } else {
                this.owner.m_5552_(stack, 0.1f);
            }
            slot.setContents(ItemStack.f_41583_);
        }
    }

    private void syncToSelf() {
        this.syncTo((Player)this.owner);
    }

    protected void syncTo(Player target) {
        SyncBeltSlotContents message = new SyncBeltSlotContents((Player)this.owner, this);
        ToolBelt.channel.sendTo((Object)message, ((ServerPlayer)target).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    protected void syncTo(PacketDistributor.PacketTarget target) {
        SyncBeltSlotContents message = new SyncBeltSlotContents((Player)this.owner, this);
        ToolBelt.channel.send(target, (Object)message);
    }

    private BeltExtensionSlot(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    @Nonnull
    public LivingEntity getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public ImmutableList<IExtensionSlot> getSlots() {
        return this.slots;
    }

    @Override
    public void onContentsChanged(IExtensionSlot slot) {
    }

    @Nonnull
    public IExtensionSlot getBelt() {
        return this.belt;
    }

    private void tickAllSlots() {
        for (IExtensionSlot slot : this.slots) {
            ((ExtensionSlotItemHandler)slot).onWornTick();
        }
    }

    public void setAll(NonNullList<ItemStack> stacks) {
        ImmutableList<IExtensionSlot> slots = this.getSlots();
        for (int i = 0; i < slots.size(); ++i) {
            ((IExtensionSlot)slots.get(i)).setContents((ItemStack)stacks.get(i));
        }
    }

    public CompoundTag serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.inventory.deserializeNBT(nbt);
    }

    static class AttachHandlers {
        AttachHandlers() {
        }

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            final Entity entity = (Entity)event.getObject();
            if (entity instanceof Player || entity instanceof ArmorStand) {
                event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                    final BeltExtensionSlot extensionContainer;
                    final LazyOptional<BeltExtensionSlot> extensionContainerSupplier;
                    {
                        this.extensionContainer = new BeltExtensionSlot((LivingEntity)entity){

                            @Override
                            public void onContentsChanged(IExtensionSlot slot) {
                                if (!ConfigData.customBeltSlotEnabled) {
                                    return;
                                }
                                if (!this.getOwner().f_19853_.f_46443_) {
                                    this.syncTo(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getOwner));
                                }
                            }
                        };
                        this.extensionContainerSupplier = LazyOptional.of(() -> this.extensionContainer);
                    }

                    public CompoundTag serializeNBT() {
                        BeltExtensionSlot.printDebugLog("Saving belt slot data for player {}({})", entity.m_6302_(), entity.m_20148_());
                        return this.extensionContainer.serializeNBT();
                    }

                    public void deserializeNBT(CompoundTag nbt) {
                        this.extensionContainer.deserializeNBT(nbt);
                        BeltExtensionSlot.printDebugLog("Read belt slot data for player {}({})", entity.m_6302_(), entity.m_20148_());
                    }

                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                        if (CAPABILITY == capability) {
                            return this.extensionContainerSupplier.cast();
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        }
    }

    private static class EventHandlers {
        private EventHandlers() {
        }

        @SubscribeEvent
        public void joinWorld(PlayerEvent.PlayerLoggedInEvent event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            Player target = event.getEntity();
            if (target.f_19853_.f_46443_) {
                return;
            }
            BeltExtensionSlot.get((LivingEntity)target).ifPresent(BeltExtensionSlot::syncToSelf);
        }

        @SubscribeEvent
        public void joinWorld(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            Player target = event.getEntity();
            if (target.f_19853_.f_46443_) {
                return;
            }
            BeltExtensionSlot.get((LivingEntity)target).ifPresent(BeltExtensionSlot::syncToSelf);
        }

        @SubscribeEvent
        public void track(PlayerEvent.StartTracking event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            Entity target = event.getTarget();
            if (target.f_19853_.f_46443_) {
                return;
            }
            if (target instanceof Player) {
                BeltExtensionSlot.get((LivingEntity)target).ifPresent(BeltExtensionSlot::syncToSelf);
            }
        }

        @SubscribeEvent
        public void entityTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (ConfigData.customBeltSlotEnabled) {
                BeltExtensionSlot.get((LivingEntity)event.player).ifPresent(BeltExtensionSlot::tickAllSlots);
            } else {
                BeltExtensionSlot.get((LivingEntity)event.player).ifPresent(BeltExtensionSlot::dropContents);
            }
        }

        @SubscribeEvent
        public void playerDeath(LivingDropsEvent event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            LivingEntity entity = event.getEntity();
            BeltExtensionSlot.get(entity).ifPresent(instance -> {
                BeltExtensionSlot.printDebugLog("Processing belt slot data for entity death {}({})", entity.m_6302_(), entity.m_20148_());
                IExtensionSlot belt = instance.getBelt();
                ItemStack stack = belt.getContents();
                if (EnchantmentHelper.m_44924_((ItemStack)stack)) {
                    stack = ItemStack.f_41583_;
                    belt.setContents(stack);
                }
                if (stack.m_41613_() > 0) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (!entity.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && !player.m_5833_()) {
                            BeltExtensionSlot.printDebugLog("Entity is player, and keepInventory is not set. Spilling...", new Object[0]);
                            Collection old = entity.captureDrops(event.getDrops());
                            player.m_7197_(stack, true, false);
                            entity.captureDrops(old);
                            belt.setContents(ItemStack.f_41583_);
                        }
                    } else {
                        entity.m_19983_(stack);
                        belt.setContents(ItemStack.f_41583_);
                    }
                }
            });
        }

        @SubscribeEvent
        public void playerClone(PlayerEvent.Clone event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            Player oldPlayer = event.getOriginal();
            oldPlayer.revive();
            Player newPlayer = event.getEntity();
            BeltExtensionSlot.printDebugLog("Processing respawn for entity {}({})", newPlayer.m_6302_(), newPlayer.m_20148_());
            BeltExtensionSlot.get((LivingEntity)oldPlayer).ifPresent(oldBelt -> {
                BeltExtensionSlot.printDebugLog("Old entity has data, copying...", new Object[0]);
                ItemStack stack = oldBelt.getBelt().getContents();
                BeltExtensionSlot.get((LivingEntity)newPlayer).map(newBelt -> {
                    LOGGER.warn("New entity has data, contents assigned.");
                    newBelt.getBelt().setContents(stack);
                    return Unit.INSTANCE;
                }).orElseGet(() -> {
                    if (stack.m_41613_() > 0) {
                        LOGGER.warn("New entity doesn't have capability attached, dropping item to the ground!");
                        oldPlayer.m_7197_(stack, true, false);
                    }
                    return Unit.INSTANCE;
                });
            });
        }
    }
}

