/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    private static Set<ItemStack> blackList;
    private static Set<ItemStack> whiteList;
    public static boolean showBeltOnPlayers;
    public static float beltItemScale;
    public static boolean releaseToSwap;
    public static boolean clipMouseToCircle;
    public static boolean allowClickOutsideBounds;
    public static boolean displayEmptySlots;
    public static boolean enableSewingKitSupport;
    public static ThreeWayChoice anvilUpgrading;
    public static boolean enableAnvilUpgrading;
    public static ThreeWayChoice gridCrafting;
    public static boolean enableNormalCrafting;
    public static ThreeWayChoice customBeltSlotMode;
    public static boolean customBeltSlotEnabled;

    public static boolean curiosPresent() {
        return ModList.get().isLoaded("curios");
    }

    public static boolean sewingKitPresent() {
        return ModList.get().isLoaded("sewingkit");
    }

    public static void refreshClient() {
        showBeltOnPlayers = (Boolean)ConfigData.CLIENT.showBeltOnPlayers.get();
        beltItemScale = (float)((Double)ConfigData.CLIENT.beltItemScale.get()).doubleValue();
        releaseToSwap = (Boolean)ConfigData.CLIENT.releaseToSwap.get();
        clipMouseToCircle = (Boolean)ConfigData.CLIENT.clipMouseToCircle.get();
        allowClickOutsideBounds = (Boolean)ConfigData.CLIENT.allowClickOutsideBounds.get();
        displayEmptySlots = (Boolean)ConfigData.CLIENT.displayEmptySlots.get();
    }

    public static void refreshCommon() {
        enableSewingKitSupport = (Boolean)ConfigData.COMMON.enableSewingKitSupport.get();
        anvilUpgrading = (ThreeWayChoice)((Object)ConfigData.COMMON.anvilUpgrading.get());
        enableAnvilUpgrading = anvilUpgrading == ThreeWayChoice.ON || anvilUpgrading == ThreeWayChoice.AUTO && !ConfigData.sewingKitPresent();
        gridCrafting = (ThreeWayChoice)((Object)ConfigData.COMMON.gridCrafting.get());
        enableNormalCrafting = gridCrafting == ThreeWayChoice.ON || gridCrafting == ThreeWayChoice.AUTO && !ConfigData.sewingKitPresent();
        customBeltSlotMode = (ThreeWayChoice)((Object)ConfigData.COMMON.customBeltSlotMode.get());
        customBeltSlotEnabled = customBeltSlotMode == ThreeWayChoice.ON || customBeltSlotMode == ThreeWayChoice.AUTO && !ConfigData.curiosPresent();
    }

    public static void refreshServer() {
        blackList = ((List)ConfigData.SERVER.blacklist.get()).stream().map(ConfigData::parseItemStack).collect(Collectors.toSet());
        whiteList = ((List)ConfigData.SERVER.whitelist.get()).stream().map(ConfigData::parseItemStack).collect(Collectors.toSet());
    }

    private static ItemStack parseItemStack(String itemString) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString));
        if (item == null || item == Items.f_41852_) {
            ToolBelt.logger.warn("Could not find item " + itemString);
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item);
    }

    public static boolean isItemStackAllowed(ItemStack stack) {
        if (stack.m_41613_() <= 0) {
            return true;
        }
        if (whiteList.stream().anyMatch(s -> ItemStack.m_41656_((ItemStack)s, (ItemStack)stack))) {
            return true;
        }
        if (blackList.stream().anyMatch(s -> ItemStack.m_41656_((ItemStack)s, (ItemStack)stack))) {
            return false;
        }
        if (stack.m_41720_() instanceof ToolBeltItem) {
            return false;
        }
        return stack.m_41741_() == 1;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        blackList = Sets.newHashSet();
        whiteList = Sets.newHashSet();
        showBeltOnPlayers = true;
        beltItemScale = 0.5f;
        releaseToSwap = false;
        clipMouseToCircle = true;
        allowClickOutsideBounds = true;
        displayEmptySlots = true;
        enableSewingKitSupport = true;
        anvilUpgrading = ThreeWayChoice.AUTO;
        enableAnvilUpgrading = true;
        gridCrafting = ThreeWayChoice.AUTO;
        enableNormalCrafting = true;
        customBeltSlotMode = ThreeWayChoice.AUTO;
        customBeltSlotEnabled = true;
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue showBeltOnPlayers;
        public final ForgeConfigSpec.DoubleValue beltItemScale;
        public final ForgeConfigSpec.BooleanValue releaseToSwap;
        public final ForgeConfigSpec.BooleanValue clipMouseToCircle;
        public final ForgeConfigSpec.BooleanValue allowClickOutsideBounds;
        public final ForgeConfigSpec.BooleanValue displayEmptySlots;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Options for customizing the display of tools on the player").push("display");
            this.showBeltOnPlayers = builder.comment("If set to FALSE, the belts and tools will NOT draw on players.").translation("text.toolbelt.config.show_belt_on_players").define("showBeltOnPlayers", true);
            this.beltItemScale = builder.comment("Changes the scale of items on the belt.").translation("text.toolbelt.config.belt_item_scale").defineInRange("beltItemScale", 0.5, 0.1, 2.0);
            builder.pop();
            builder.comment("Options for customizing the radial menu").push("menu");
            this.releaseToSwap = builder.comment("If set to TRUE, releasing the menu key (R) will activate the swap. Requires a click otherwise (default).").translation("text.toolbelt.config.release_to_swap").define("releaseToSwap", false);
            this.clipMouseToCircle = builder.comment("If set to TRUE, the radial menu will try to prevent the mouse from leaving the outer circle.").translation("text.toolbelt.config.clip_mouse_to_circle").define("clipMouseToCircle", false);
            this.allowClickOutsideBounds = builder.comment("If set to TRUE, the radial menu will allow clicking outside the outer circle to activate the items.").translation("text.toolbelt.config.click_outside_bounds").define("allowClickOutsideBounds", false);
            this.displayEmptySlots = builder.comment("If set to TRUE, the radial menu will always display all the slots, even when empty, and will allow choosing which empty slot to insert into.").translation("text.toolbelt.config.display_empty_slots").define("displayEmptySlots", false);
            builder.pop();
        }
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.EnumValue<ThreeWayChoice> customBeltSlotMode;
        public final ForgeConfigSpec.EnumValue<ThreeWayChoice> anvilUpgrading;
        public final ForgeConfigSpec.EnumValue<ThreeWayChoice> gridCrafting;
        public final ForgeConfigSpec.BooleanValue enableSewingKitSupport;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.enableSewingKitSupport = builder.comment("If set to FALSE, support for sewing recipes will not be enabled regardless of the mod's presence.").translation("text.toolbelt.config.enable_sewing_kit_support").define("enableSewingKitSupport", true);
            this.anvilUpgrading = builder.comment("If AUTO, the crafting and upgrade recipes will use the Sewing mechanics if the Sewing Kit mod is present. Off disables anvil upgrading regardless.").translation("text.toolbelt.config.anvil_upgrading").defineEnum("anvilUpgrading", (Enum)ThreeWayChoice.AUTO);
            this.gridCrafting = builder.comment("If AUTO, the belt and pouch crafting recipes will be disabled if the Sewing Kit mod is present, sewing recipes will be used instead.").translation("text.toolbelt.config.enable_grid_crafting").defineEnum("enableGridCraftingRecipes", (Enum)ThreeWayChoice.AUTO);
            this.customBeltSlotMode = builder.comment("If AUTO, the belt slot will be disabled if Curios is present. If OFF, the belt slot will be disabled permanently.").translation("text.toolbelt.config.custom_belt_slot_mode").defineEnum("customBeltSlotMode", (Enum)ThreeWayChoice.ON);
            builder.pop();
        }
    }

    public static enum ThreeWayChoice implements StringRepresentable
    {
        OFF("off"),
        AUTO("auto"),
        ON("on");

        private final String name;

        private ThreeWayChoice(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static ThreeWayChoice byName(String name) {
            for (ThreeWayChoice mode : ThreeWayChoice.values()) {
                if (!mode.name.equalsIgnoreCase(name)) continue;
                return mode;
            }
            return ON;
        }

        public static String[] names() {
            return (String[])Arrays.stream(ThreeWayChoice.values()).map(ThreeWayChoice::m_7912_).toArray(String[]::new);
        }
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.whitelist = builder.comment("List of items to force-allow placing in the belt. Takes precedence over blacklist.").translation("text.toolbelt.config.whitelist").defineList("whitelist", (List)Lists.newArrayList(), o -> o instanceof String);
            this.blacklist = builder.comment("List of items to disallow from placing in the belt. (whitelist takes precedence)").translation("text.toolbelt.config.blacklist").defineList("blacklist", (List)Lists.newArrayList(), o -> o instanceof String);
            builder.pop();
        }
    }
}

