/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import net.konwboy.tumbleweed.common.EntityTumbleweed;
import net.konwboy.tumbleweed.services.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class Spawner {
    private static final int TRY_SPAWN_TICKS = 200;
    private static final int MOB_COUNT_DIV = 289;
    private static final int SEARCH_RADIUS = 2;
    private static final int SPAWN_ATTEMPTS = 10;
    private static final class_6862<class_1959> BIOME_WHITELIST = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)new class_2960("tumbleweed", "whitelist"));
    private static final class_6862<class_2248> SPAWNER_BLOCKS = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960("tumbleweed", "spawners"));

    public static void endWorldTick(class_1299<EntityTumbleweed> type, class_3218 world) {
        if (world.method_8510() % 200L == 7L) {
            world.method_16107().method_15396("spawn_tumbleweed");
            Spawner.trySpawn(type, world);
            world.method_16107().method_15407();
        }
        world.method_18198(type, t -> true).forEach(EntityTumbleweed::tickDespawn);
    }

    private static void trySpawn(class_1299<EntityTumbleweed> type, class_3218 world) {
        if (!world.method_8450().method_8355(class_1928.field_19390)) {
            return;
        }
        HashSet eligibleChunksForSpawning = Sets.newHashSet();
        for (class_1657 entityplayer : world.method_18456()) {
            if (entityplayer.method_7325()) continue;
            int playerX = class_3532.method_15357((double)(entityplayer.method_23317() / 16.0));
            int playerZ = class_3532.method_15357((double)(entityplayer.method_23321() / 16.0));
            for (int x = 8; x >= -8; --x) {
                for (int z = 8; z >= -8; --z) {
                    class_6880 biome;
                    boolean corner = x == -8 || x == 8 || z == -8 || z == 8;
                    class_1923 chunk = new class_1923(x + playerX, z + playerZ);
                    if (eligibleChunksForSpawning.contains(chunk) || corner || !world.method_8621().method_11951(chunk) || Spawner.isNonEntityProcessing(world, chunk.method_8323()) || !(biome = world.method_23753(new class_2338(chunk.method_8326() + 8, 0, chunk.method_8328() + 8))).method_40220(BIOME_WHITELIST)) continue;
                    eligibleChunksForSpawning.add(chunk);
                }
            }
        }
        ArrayList chunkList = Lists.newArrayList((Iterable)eligibleChunksForSpawning);
        Collections.shuffle(chunkList);
        class_2338 worldSpawn = new class_2338(world.method_8401().method_215(), world.method_8401().method_144(), world.method_8401().method_166());
        long current = world.method_18198(type, e -> true).size();
        int max = class_3532.method_15384((double)((double)(Services.CONFIG.maxPerPlayer() * eligibleChunksForSpawning.size()) / 289.0));
        block3: for (class_1923 chunk : chunkList) {
            if (current > (long)max) break;
            if (world.field_9229.method_43058() > Services.CONFIG.spawnChance()) continue;
            class_2338 start = Spawner.getRandomSurfacePosition((class_1937)world, chunk.field_9181, chunk.field_9180);
            class_2338 spawner = null;
            block4: for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    class_2338 check = world.method_8598(class_2902.class_2903.field_13203, new class_2338(start.method_10263() + x, 0, start.method_10260() + z));
                    class_2680 state = world.method_8320(check);
                    if (!state.method_41520().method_40220(SPAWNER_BLOCKS) || !world.method_22348(check)) continue;
                    spawner = check;
                    continue block4;
                }
            }
            if (spawner == null) continue;
            int packSize = 1 + (world.field_9229.method_43057() < 0.2f ? 1 : 0);
            int packSpawned = 0;
            for (int i = 0; i < 10; ++i) {
                int z;
                int y;
                int x = spawner.method_10263() + world.field_9229.method_43048(5) - world.field_9229.method_43048(5);
                if (Spawner.isNonEntityProcessing(world, new class_2338(x, y = spawner.method_10264() + world.field_9229.method_43048(2) - world.field_9229.method_43048(2), z = spawner.method_10260() + world.field_9229.method_43048(5) - world.field_9229.method_43048(5))) || !world.method_8320(new class_2338(x, y - 1, z)).method_26225() || world.method_18458((double)x, (double)y, (double)z, 32.0)) continue;
                if (worldSpawn.method_10262(new class_2382(x, y, z)) < 576.0) continue;
                EntityTumbleweed entity = (EntityTumbleweed)type.method_5883((class_1937)world);
                entity.setSize(world.field_9229.method_43048(5) - 2);
                entity.method_5808((double)x + 0.5, (double)y + 0.5 + 0.5 * world.field_9229.method_43058(), (double)z + 0.5, 0.0f, 0.0f);
                if (entity.isNotColliding()) {
                    ++current;
                    ++packSpawned;
                    world.method_8649((class_1297)entity);
                }
                if (packSpawned == packSize) continue block3;
            }
        }
    }

    private static class_2338 getRandomSurfacePosition(class_1937 world, int chunkX, int chunkZ) {
        class_2818 chunk = world.method_8497(chunkX, chunkZ);
        int x = chunkX * 16 + world.field_9229.method_43048(14) + 2;
        int z = chunkZ * 16 + world.field_9229.method_43048(14) + 2;
        int y = chunk.method_12005(class_2902.class_2903.field_13203, x, z);
        return new class_2338(x, y, z);
    }

    public static boolean isNonEntityProcessing(class_3218 world, class_2338 pos) {
        return !world.method_37118(pos);
    }
}

