/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.konwboy.tumbleweed.Constants;
import net.konwboy.tumbleweed.client.ModelTumbleweed;
import net.konwboy.tumbleweed.common.EntityTumbleweed;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RenderTumbleweed
extends EntityRenderer<EntityTumbleweed> {
    public static final ModelLayerLocation MAIN_LAYER = new ModelLayerLocation(Constants.TUMBLEWEED_ENTITY, "main");
    private static final ResourceLocation TEXTURE = new ResourceLocation("tumbleweed", "textures/entity/tumbleweed.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110473_((ResourceLocation)TEXTURE);
    private final ModelTumbleweed model;
    private static final double THRESHOLD = 0.9995;

    public RenderTumbleweed(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelTumbleweed(context.m_174023_(MAIN_LAYER));
        this.f_114477_ = 0.4f;
        this.f_114478_ = 0.8f;
    }

    public void render(EntityTumbleweed entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn) {
        float alpha = 1.0f - (float)entity.fadeProgress / 80.0f;
        this.f_114478_ = alpha * 0.7f;
        this.f_114477_ = entity.m_20205_() * 0.5f;
        matrixStack.m_85836_();
        float size = 1.0f + (float)entity.getSize() / 8.0f;
        float stretch = Mth.m_14179_((float)partialTicks, (float)entity.prevStretch, (float)entity.stretch);
        matrixStack.m_85837_(0.0, (double)(entity.m_20206_() * 0.3f), 0.0);
        matrixStack.m_85841_(size, size, size);
        matrixStack.m_85841_(1.0f, stretch, 1.0f);
        matrixStack.m_85845_(RenderTumbleweed.slerp(entity.prevQuat, entity.quat, partialTicks));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(entity.rot1));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(entity.rot2));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(entity.rot3));
        VertexConsumer buf = bufferIn.m_6299_(RENDER_TYPE);
        this.model.m_7695_(matrixStack, buf, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(EntityTumbleweed entity) {
        return TEXTURE;
    }

    public static Quaternion slerp(Quaternion v0, Quaternion v1, float t) {
        float dot = v0.m_80140_() * v1.m_80140_() + v0.m_80150_() * v1.m_80150_() + v0.m_80153_() * v1.m_80153_() + v0.m_80156_() * v1.m_80156_();
        if (dot < 0.0f) {
            v1 = new Quaternion(-v1.m_80140_(), -v1.m_80150_(), -v1.m_80153_(), -v1.m_80156_());
            dot = -dot;
        }
        if ((double)dot > 0.9995) {
            float x = Mth.m_14179_((float)t, (float)v0.m_80140_(), (float)v1.m_80140_());
            float y = Mth.m_14179_((float)t, (float)v0.m_80150_(), (float)v1.m_80150_());
            float z = Mth.m_14179_((float)t, (float)v0.m_80153_(), (float)v1.m_80153_());
            float w = Mth.m_14179_((float)t, (float)v0.m_80156_(), (float)v1.m_80156_());
            return new Quaternion(x, y, z, w);
        }
        float angle01 = (float)Math.acos(dot);
        float angle0t = angle01 * t;
        float sin0t = Mth.m_14031_((float)angle0t);
        float sin01 = Mth.m_14031_((float)angle01);
        float sin1t = Mth.m_14031_((float)(angle01 - angle0t));
        float s1 = sin0t / sin01;
        float s0 = sin1t / sin01;
        return new Quaternion(s0 * v0.m_80140_() + s1 * v1.m_80140_(), s0 * v0.m_80150_() + s1 * v1.m_80150_(), s0 * v0.m_80153_() + s1 * v1.m_80153_(), s0 * v0.m_80156_() + s1 * v1.m_80156_());
    }
}

