/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.konwboy.tumbleweed.Tumbleweed;
import net.konwboy.tumbleweed.common.DropList;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TumbleweedConfig {
    public static double spawnChance;
    public static int maxPerPlayer;
    public static boolean enableDrops;
    public static boolean damageCrops;
    public static boolean dropOnlyByPlayer;
    private static final ForgeConfigSpec.ConfigValue<Double> SPAWN_CHANCE;
    private static final ForgeConfigSpec.ConfigValue<Integer> MAX_PER_PLAYER;
    private static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_DROPS;
    private static final ForgeConfigSpec.ConfigValue<Boolean> DAMAGE_CROPS;
    private static final ForgeConfigSpec.ConfigValue<Boolean> DROP_ONLY_BY_PLAYER;
    private static final ForgeConfigSpec.ConfigValue<List<String>> DROP_DATA;
    private static final ForgeConfigSpec.ConfigValue<List<String>> BLOCK_DATA;
    private static final ForgeConfigSpec.ConfigValue<List<String>> BIOME_DATA;
    public static final ForgeConfigSpec SPEC;
    private static final String[] DEFAULT_DROPS;
    private static final String[] DEFAULT_BLOCKS;
    public static Set<ResourceLocation> biomeWhitelist;
    public static Set<ResourceLocation> spawningBlocks;
    public static boolean canLoad;

    public static void load() {
        if (!canLoad) {
            return;
        }
        biomeWhitelist.clear();
        spawningBlocks.clear();
        spawnChance = (Double)SPAWN_CHANCE.get();
        maxPerPlayer = (Integer)MAX_PER_PLAYER.get();
        enableDrops = (Boolean)ENABLE_DROPS.get();
        damageCrops = (Boolean)DAMAGE_CROPS.get();
        dropOnlyByPlayer = (Boolean)DROP_ONLY_BY_PLAYER.get();
        DropList.load((List)DROP_DATA.get());
        for (String entry : (List)BIOME_DATA.get()) {
            ResourceLocation id = new ResourceLocation(entry);
            if (ForgeRegistries.BIOMES.containsKey(id)) {
                biomeWhitelist.add(id);
                continue;
            }
            Tumbleweed.logger.warn("Biome {} is invalid.", (Object)id);
        }
        for (String entry : (List)BLOCK_DATA.get()) {
            ResourceLocation location = new ResourceLocation(entry);
            if (ForgeRegistries.BLOCKS.containsKey(location)) {
                spawningBlocks.add(location);
                continue;
            }
            Tumbleweed.logger.warn("Block {} is invalid.", (Object)entry);
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            TumbleweedConfig.load();
        }
    }

    static {
        DEFAULT_DROPS = new String[]{"3 minecraft:bone", "3 minecraft:dead_bush", "3 minecraft:string", "3 minecraft:feather", "3 minecraft:wheat", "3 minecraft:stick", "3 minecraft:sugar_cane", "2 minecraft:melon_seeds", "2 minecraft:pumpkin_seeds", "2 minecraft:gold_nugget", "1 minecraft:name_tag", "1 minecraft:saddle", "1 minecraft:emerald", "1 minecraft:diamond", "1 minecraft:iron_ingot", "1 minecraft:gold_ingot"};
        DEFAULT_BLOCKS = new String[]{"minecraft:dead_bush"};
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SPAWN_CHANCE = builder.comment("Chance a tumbleweed spawns in a chunk.").define("spawnChance", (Object)0.5);
        MAX_PER_PLAYER = builder.comment("Maximum number of tumbleweeds existing per player (technically 17x17 loaded chunks).").define("maxPerPlayer", (Object)8);
        ENABLE_DROPS = builder.define("enableDrops", true);
        DAMAGE_CROPS = builder.comment("Should tumbleweeds destroy crops they touch.").define("damageCrops", true);
        DROP_ONLY_BY_PLAYER = builder.comment("Drop items only when destroyed by player (normally also drops on lava and cactus damage, for example).").define("dropOnlyByPlayer", false);
        DROP_DATA = builder.comment(new String[]{"These items will drop from a tumbleweed upon destroying.", "The item format allows specifying item tags and NBT data. It follows vanilla's command argument format.", "The amount parameter is optional.", "weight item amount", "Example entry: 2 minecraft:arrow{display:{Name:'{\"text\":\"Cool arrow\"}'}} 20"}).define("drops", (Object)Lists.newArrayList((Object[])DEFAULT_DROPS));
        BLOCK_DATA = builder.comment(new String[]{"Blocks in which tumbleweeds can spawn. Only works with non-solid blocks.", "The actual location also requires sky access and a solid block below it.", "<mod>:<block>"}).define("spawningBlocks", (Object)Lists.newArrayList((Object[])DEFAULT_BLOCKS));
        BIOME_DATA = builder.comment(new String[]{"If not empty, tumbleweeds spawn ONLY in the specified biomes. Else they appear in all hot, dry biomes.", "Example entry: minecraft:desert"}).define("biomeWhitelist", (Object)Lists.newArrayList());
        SPEC = builder.build();
        biomeWhitelist = Sets.newHashSet();
        spawningBlocks = Sets.newHashSet();
        canLoad = false;
    }
}

