/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.mojang.math.Quaternion;
import java.util.List;
import java.util.Random;
import net.konwboy.tumbleweed.common.Spawner;
import net.konwboy.tumbleweed.services.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EntityTumbleweed
extends Entity {
    public static final int FADE_TIME = 80;
    private static final int DESPAWN_RANGE = 110;
    private static final float BASE_SIZE = 0.75f;
    private static final double WIND_X = -0.0625;
    private static final double WIND_Z = -0.0625;
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(EntityTumbleweed.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CUSTOM_WIND_ENABLED = SynchedEntityData.m_135353_(EntityTumbleweed.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> CUSTOM_WIND_X = SynchedEntityData.m_135353_(EntityTumbleweed.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CUSTOM_WIND_Z = SynchedEntityData.m_135353_(EntityTumbleweed.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> FADING = SynchedEntityData.m_135353_(EntityTumbleweed.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int age;
    public int fadeProgress;
    public boolean persistent;
    private double windMod;
    private int lifetime;
    private float angularX;
    private float angularZ;
    public float stretch = 1.0f;
    public float prevStretch = 1.0f;
    private boolean prevVerticalCol;
    private Vec3 prevMotion = Vec3.f_82478_;
    private int despawnCounter;
    public float rot1;
    public float rot2;
    public float rot3;
    public Quaternion quat;
    public Quaternion prevQuat;

    public EntityTumbleweed(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.m_20234_(this.m_19879_());
        if (this.f_19853_.f_46443_) {
            this.initClient();
        }
    }

    private void initClient() {
        this.rot1 = 360.0f * this.f_19853_.f_46441_.m_188501_();
        this.rot2 = 360.0f * this.f_19853_.f_46441_.m_188501_();
        this.rot3 = 360.0f * this.f_19853_.f_46441_.m_188501_();
        this.quat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        this.prevQuat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)2);
        this.f_19804_.m_135372_(CUSTOM_WIND_ENABLED, (Object)false);
        this.f_19804_.m_135372_(CUSTOM_WIND_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CUSTOM_WIND_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FADING, (Object)false);
        this.m_6210_();
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Size", this.getSize());
        nbt.m_128379_("CustomWindEnabled", this.getCustomWindEnabled());
        nbt.m_128347_("CustomWindX", this.getCustomWindX());
        nbt.m_128347_("CustomWindZ", this.getCustomWindZ());
        nbt.m_128379_("Persistent", this.persistent);
        AABB bb = this.m_20191_();
        nbt.m_128365_("AABB", (Tag)this.m_20063_(new double[]{bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_}));
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("Size")) {
            this.f_19804_.m_135381_(SIZE, (Object)nbt.m_128451_("Size"));
        }
        this.f_19804_.m_135381_(CUSTOM_WIND_ENABLED, (Object)nbt.m_128471_("CustomWindEnabled"));
        this.f_19804_.m_135381_(CUSTOM_WIND_X, (Object)Float.valueOf(nbt.m_128457_("CustomWindX")));
        this.f_19804_.m_135381_(CUSTOM_WIND_Z, (Object)Float.valueOf(nbt.m_128457_("CustomWindZ")));
        this.persistent = nbt.m_128471_("Persistent");
        if (nbt.m_128441_("AABB")) {
            ListTag aabb = nbt.m_128437_("AABB", 6);
            this.m_20011_(new AABB(aabb.m_128772_(0), aabb.m_128772_(1), aabb.m_128772_(2), aabb.m_128772_(3), aabb.m_128772_(4), aabb.m_128772_(5)));
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(SIZE)) {
            this.m_6210_();
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        float mcSize = 0.75f + (float)this.getSize() * 0.125f;
        return EntityDimensions.m_20395_((float)(this.f_19853_.f_46443_ ? mcSize - 9.765625E-4f : mcSize), (float)mcSize);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        Random rand = new Random(id);
        this.windMod = 1.05 - 0.1 * rand.nextDouble();
        this.lifetime = 2400 + rand.nextInt(200);
    }

    public void m_8119_() {
        double windZ;
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.preTickClient();
        }
        if (this.m_20202_() != null) {
            this.m_20256_(Vec3.f_82478_);
            return;
        }
        if (!this.m_20069_()) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.012, 0.0));
        }
        this.prevMotion = this.m_20184_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        double windX = this.getCustomWindEnabled() ? this.getCustomWindX() : -0.0625 * this.windMod;
        double d = windZ = this.getCustomWindEnabled() ? this.getCustomWindZ() : -0.0625 * this.windMod;
        if (this.m_20069_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.95, 1.0, 0.95));
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.02, 0.0));
            windZ = 0.0;
            windX = 0.0;
        } else if (windX != 0.0 || windZ != 0.0) {
            this.m_20334_(windX, this.m_20184_().f_82480_, windZ);
        }
        if (this.f_19853_.f_46443_) {
            this.tickClient();
        }
        if (this.f_19861_) {
            if (windX * windX + windZ * windZ >= 0.0025000000000000005) {
                this.m_20334_(this.m_20184_().f_82479_, Math.max(-this.prevMotion.f_82480_ * 0.7, 0.24 - (double)Math.abs(this.getSize()) * 0.02), this.m_20184_().f_82481_);
            } else {
                this.m_20334_(this.m_20184_().f_82479_, -this.prevMotion.f_82480_ * 0.7, this.m_20184_().f_82481_);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(0.98, 0.98, 0.98));
        this.collideWithNearbyEntities();
        if (!this.f_19853_.f_46443_) {
            this.age += this.f_19862_ || this.m_20069_() ? 8 : 1;
            if (this.age > this.lifetime && this.fadeProgress == 0) {
                this.f_19804_.m_135381_(FADING, (Object)true);
            }
            this.tryDespawn();
        }
        if (this.isFading()) {
            ++this.fadeProgress;
            if (this.fadeProgress > 80) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private void preTickClient() {
        this.prevStretch = this.stretch;
        this.stretch *= 1.2f;
        if (this.stretch > 1.0f) {
            this.stretch = 1.0f;
        }
        this.prevQuat = new Quaternion(this.quat);
    }

    private void tickClient() {
        if (!this.prevVerticalCol && this.f_19863_) {
            this.stretch *= 0.7f;
        }
        this.prevVerticalCol = this.f_19863_;
        float motionAngleX = (float)(-this.prevMotion.f_82479_) / (this.m_20205_() * 0.5f);
        float motionAngleZ = (float)this.prevMotion.f_82481_ / (this.m_20205_() * 0.5f);
        if (this.f_19861_) {
            this.angularX = motionAngleX;
            this.angularZ = motionAngleZ;
        }
        if (this.m_20069_()) {
            this.angularX += motionAngleX * 0.2f;
            this.angularZ += motionAngleZ * 0.2f;
        }
        float resistance = this.m_20069_() ? 0.9f : 0.96f;
        this.angularX *= resistance;
        this.angularZ *= resistance;
        Quaternion temp = new Quaternion(this.angularZ, 0.0f, this.angularX, false);
        temp.m_80148_(this.quat);
        this.quat = temp;
    }

    private void tryDespawn() {
        if (this.shouldPersist()) {
            this.age = 0;
            return;
        }
        Player player = this.f_19853_.m_45930_((Entity)this, -1.0);
        if (player != null && player.m_20280_((Entity)this) > 12100.0) {
            this.m_142687_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        }
    }

    public boolean shouldPersist() {
        return this.persistent || this.m_20202_() != null;
    }

    public void tickDespawn() {
        this.despawnCounter = !this.shouldPersist() && this.f_19797_ > 0 && Spawner.isNonEntityProcessing((ServerLevel)this.f_19853_, this.m_20183_()) ? ++this.despawnCounter : 0;
        if (this.despawnCounter > 20) {
            this.m_146870_();
        }
    }

    public boolean m_6783_(double distance) {
        return distance < 16384.0;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42656_ && stack.m_41788_()) {
            if (!this.f_19853_.f_46443_) {
                this.m_6593_(stack.m_41786_());
                this.persistent = true;
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            SoundType sound = SoundType.f_56740_;
            this.m_5496_(sound.m_56775_(), (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
            Entity killer = source.m_7639_();
            if (killer instanceof Player) {
                ((Player)killer).m_36246_(Stats.f_12986_.m_12902_((Object)this.m_6095_()));
            }
            if (Services.CONFIG.enableDrops() && (killer instanceof Player || !Services.CONFIG.dropOnlyByPlayer())) {
                this.dropFromLootTable(source);
            }
        }
        return true;
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack itemStack, float yOffset) {
        ItemEntity item = super.m_5552_(itemStack, yOffset);
        if (item == null) {
            return null;
        }
        item.m_20334_(0.0, 0.2, 0.0);
        return item;
    }

    protected void dropFromLootTable(DamageSource damageSource) {
        LootTable loottable = this.f_19853_.m_7654_().m_129898_().m_79217_(this.m_6095_().m_20677_());
        LootContext.Builder lootcontext$builder = this.createLootContext(damageSource);
        LootContext ctx = lootcontext$builder.m_78975_(LootContextParamSets.f_81415_);
        loottable.m_230922_(ctx).forEach(arg_0 -> ((EntityTumbleweed)this).m_19983_(arg_0));
    }

    protected LootContext.Builder createLootContext(DamageSource damageSource) {
        return new LootContext.Builder((ServerLevel)this.f_19853_).m_230911_(this.f_19796_).m_78972_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)damageSource).m_78984_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_78984_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
    }

    public boolean m_7313_(Entity entityIn) {
        return entityIn instanceof Player && this.m_6469_(DamageSource.m_19344_((Player)((Player)entityIn)), 0.0f);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11992_, 0.15f, 1.0f);
    }

    public boolean canTumbleweedTrample(BlockState state, BlockPos pos, float fallDistance) {
        return this.f_19853_.f_46441_.m_188501_() < 0.7f && this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) && Services.CONFIG.damageCrops();
    }

    protected boolean m_6093_() {
        return false;
    }

    private void collideWithNearbyEntities() {
        List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82363_(0.2, 0.0, 0.2), Entity::m_6094_);
        for (Entity entity : list) {
            if (!this.f_19853_.f_46443_ && entity instanceof AbstractMinecart && ((AbstractMinecart)entity).m_6064_() == AbstractMinecart.Type.RIDEABLE && entity.m_20184_().f_82479_ * entity.m_20184_().f_82479_ + entity.m_20184_().f_82481_ * entity.m_20184_().f_82481_ > 0.01 && entity.m_20197_().isEmpty() && this.m_20202_() == null) {
                this.m_20329_(entity);
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
                this.f_19864_ = true;
            }
            entity.m_7334_((Entity)this);
        }
    }

    public boolean isNotColliding() {
        return this.f_19853_.m_45784_((Entity)this) && this.noBlockCollision() && !this.f_19853_.m_46855_(this.m_20191_());
    }

    private boolean noBlockCollision() {
        for (VoxelShape voxelshape : this.f_19853_.m_186434_((Entity)this, this.m_20191_())) {
            if (voxelshape.m_83281_()) continue;
            return false;
        }
        return true;
    }

    public void setSize(int size) {
        this.f_19804_.m_135381_(SIZE, (Object)size);
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(SIZE);
    }

    public double getCustomWindX() {
        return ((Float)this.f_19804_.m_135370_(CUSTOM_WIND_X)).floatValue();
    }

    public double getCustomWindZ() {
        return ((Float)this.f_19804_.m_135370_(CUSTOM_WIND_Z)).floatValue();
    }

    public boolean getCustomWindEnabled() {
        return (Boolean)this.f_19804_.m_135370_(CUSTOM_WIND_ENABLED);
    }

    public boolean isFading() {
        return (Boolean)this.f_19804_.m_135370_(FADING);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

