/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import java.util.EnumSet;
import java.util.List;
import net.konwboy.tumbleweed.common.EntityTumbleweed;
import net.konwboy.tumbleweed.mixins.SkeletonAccessor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ShootTumbleweed
extends Goal {
    private final AbstractSkeleton mob;
    private Entity target;
    private int lookTime;
    private static final float MAX_DISTANCE = 18.0f;
    private static final float MIN_DISTANCE = 9.0f;

    public ShootTumbleweed(AbstractSkeleton mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188501_() > 0.003f) {
            return false;
        }
        Entity tumbleweed = ShootTumbleweed.findTarget(this.mob.f_19853_.m_6443_(EntityTumbleweed.class, this.mob.m_20191_().m_82377_(18.0, 3.0, 18.0), e -> true), (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        if (tumbleweed == null) {
            return false;
        }
        this.target = tumbleweed;
        return true;
    }

    private static Entity findTarget(List<? extends Entity> list, LivingEntity from, double x, double y, double z) {
        double min = -1.0;
        Entity ent = null;
        for (Entity entity : list) {
            double dist = entity.m_20275_(x, y, z);
            if (!(dist > 81.0) || !(dist < 324.0) || !from.m_142582_(entity) || min != -1.0 && !(dist < min)) continue;
            ent = entity;
            min = dist;
        }
        return ent;
    }

    public boolean m_8045_() {
        return this.lookTime > 0;
    }

    public void m_8056_() {
        this.lookTime = 70;
    }

    public void m_8041_() {
        this.target = null;
        this.mob.m_21561_(false);
        this.mob.m_5810_();
        this.lookTime = 0;
    }

    private void performRangedAttack(Entity target) {
        ItemStack arrowItem = this.mob.m_6298_(this.mob.m_21120_(ProjectileUtil.m_37297_((LivingEntity)this.mob, (Item)Items.f_42411_)));
        AbstractArrow arrow = ((SkeletonAccessor)this.mob).invokeGetArrow(arrowItem, 0.1f);
        double dX = target.m_20185_() - this.mob.m_20185_();
        double dY = target.m_20227_(0.3) - arrow.m_20186_();
        double dZ = target.m_20189_() - this.mob.m_20189_();
        double dist = Math.sqrt(dX * dX + dZ * dZ);
        arrow.m_6686_(dX, dY + dist * (double)0.2f, dZ, 1.6f, 1.0f);
        this.mob.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.mob.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.mob.f_19853_.m_7967_((Entity)arrow);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        --this.lookTime;
        if (this.lookTime == 60) {
            this.mob.m_21561_(true);
        }
        if (this.target.m_6084_()) {
            if (this.lookTime == 50) {
                this.mob.m_6672_(ProjectileUtil.m_37297_((LivingEntity)this.mob, (Item)Items.f_42411_));
            }
            if (this.lookTime == 40) {
                this.performRangedAttack(this.target);
                this.mob.m_5810_();
            }
            this.mob.m_21563_().m_24946_(this.target.m_20185_(), this.mob.m_20188_(), this.target.m_20189_());
        }
        if (this.lookTime == 30) {
            this.mob.m_21561_(false);
        }
    }
}

