/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.undeadexpansion.init;

import net.mcreator.undeadexpansion.entity.DemonEntity;
import net.mcreator.undeadexpansion.entity.FracturedKnightEntity;
import net.mcreator.undeadexpansion.entity.FracturedKnightLeaderEntity;
import net.mcreator.undeadexpansion.entity.HaunterEntity;
import net.mcreator.undeadexpansion.entity.ImpactGrenadeEntity;
import net.mcreator.undeadexpansion.entity.RevenantEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class UndeadExpansionModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"undead_expansion");
    public static final RegistryObject<EntityType<RevenantEntity>> REVENANT = UndeadExpansionModEntities.register("revenant", EntityType.Builder.m_20704_(RevenantEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(RevenantEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<HaunterEntity>> HAUNTER = UndeadExpansionModEntities.register("haunter", EntityType.Builder.m_20704_(HaunterEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(HaunterEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<DemonEntity>> DEMON = UndeadExpansionModEntities.register("demon", EntityType.Builder.m_20704_(DemonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(DemonEntity::new).m_20719_().m_20699_(0.6f, 2.5f));
    public static final RegistryObject<EntityType<FracturedKnightEntity>> WANDERING_KNIGHT = UndeadExpansionModEntities.register("wandering_knight", EntityType.Builder.m_20704_(FracturedKnightEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).setCustomClientFactory(FracturedKnightEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<FracturedKnightLeaderEntity>> WANDERING_KNIGHT_LEADER = UndeadExpansionModEntities.register("wandering_knight_leader", EntityType.Builder.m_20704_(FracturedKnightLeaderEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).setCustomClientFactory(FracturedKnightLeaderEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<ImpactGrenadeEntity>> IMPACT_GRENADE_BULLET = UndeadExpansionModEntities.register("projectile_impact_grenade_bullet", EntityType.Builder.m_20704_(ImpactGrenadeEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(ImpactGrenadeEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RevenantEntity.init();
            HaunterEntity.init();
            DemonEntity.init();
            FracturedKnightEntity.init();
            FracturedKnightLeaderEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)REVENANT.get(), RevenantEntity.createAttributes().m_22265_());
        event.put((EntityType)HAUNTER.get(), HaunterEntity.createAttributes().m_22265_());
        event.put((EntityType)DEMON.get(), DemonEntity.createAttributes().m_22265_());
        event.put((EntityType)WANDERING_KNIGHT.get(), FracturedKnightEntity.createAttributes().m_22265_());
        event.put((EntityType)WANDERING_KNIGHT_LEADER.get(), FracturedKnightLeaderEntity.createAttributes().m_22265_());
    }
}

