/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.undead;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.undead.UndeadMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class UndeadModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public UndeadModElements() {
        sounds.put(new ResourceLocation("undead", "cow_monster_laugh"), new SoundEvent(new ResourceLocation("undead", "cow_monster_laugh")));
        sounds.put(new ResourceLocation("undead", "spit"), new SoundEvent(new ResourceLocation("undead", "spit")));
        sounds.put(new ResourceLocation("undead", "lostsoul_scream"), new SoundEvent(new ResourceLocation("undead", "lostsoul_scream")));
        sounds.put(new ResourceLocation("undead", "serpen_ambiemt"), new SoundEvent(new ResourceLocation("undead", "serpen_ambiemt")));
        sounds.put(new ResourceLocation("undead", "serpen_stun"), new SoundEvent(new ResourceLocation("undead", "serpen_stun")));
        sounds.put(new ResourceLocation("undead", "tape_rip"), new SoundEvent(new ResourceLocation("undead", "tape_rip")));
        sounds.put(new ResourceLocation("undead", "bomber_ready"), new SoundEvent(new ResourceLocation("undead", "bomber_ready")));
        sounds.put(new ResourceLocation("undead", "guts_ripped1"), new SoundEvent(new ResourceLocation("undead", "guts_ripped1")));
        sounds.put(new ResourceLocation("undead", "roten_damaged"), new SoundEvent(new ResourceLocation("undead", "roten_damaged")));
        sounds.put(new ResourceLocation("undead", "the_fungus_breathing"), new SoundEvent(new ResourceLocation("undead", "the_fungus_breathing")));
        sounds.put(new ResourceLocation("undead", "gas_blow"), new SoundEvent(new ResourceLocation("undead", "gas_blow")));
        sounds.put(new ResourceLocation("undead", "moon_hurt"), new SoundEvent(new ResourceLocation("undead", "moon_hurt")));
        sounds.put(new ResourceLocation("undead", "mermaid_ambient"), new SoundEvent(new ResourceLocation("undead", "mermaid_ambient")));
        sounds.put(new ResourceLocation("undead", "serpen_hurt"), new SoundEvent(new ResourceLocation("undead", "serpen_hurt")));
        sounds.put(new ResourceLocation("undead", "gg"), new SoundEvent(new ResourceLocation("undead", "gg")));
        sounds.put(new ResourceLocation("undead", "bomber_g"), new SoundEvent(new ResourceLocation("undead", "bomber_g")));
        sounds.put(new ResourceLocation("undead", "moon_ambient"), new SoundEvent(new ResourceLocation("undead", "moon_ambient")));
        sounds.put(new ResourceLocation("undead", "heavy_hurt"), new SoundEvent(new ResourceLocation("undead", "heavy_hurt")));
        sounds.put(new ResourceLocation("undead", "the_heavy_attack"), new SoundEvent(new ResourceLocation("undead", "the_heavy_attack")));
        sounds.put(new ResourceLocation("undead", "theheavy_ambient"), new SoundEvent(new ResourceLocation("undead", "theheavy_ambient")));
        sounds.put(new ResourceLocation("undead", "sucker_hurt"), new SoundEvent(new ResourceLocation("undead", "sucker_hurt")));
        sounds.put(new ResourceLocation("undead", "sucker_ambient"), new SoundEvent(new ResourceLocation("undead", "sucker_ambient")));
        sounds.put(new ResourceLocation("undead", "sucker_death"), new SoundEvent(new ResourceLocation("undead", "sucker_death")));
        sounds.put(new ResourceLocation("undead", "serpent_bitt"), new SoundEvent(new ResourceLocation("undead", "serpent_bitt")));
        sounds.put(new ResourceLocation("undead", "cower_huts"), new SoundEvent(new ResourceLocation("undead", "cower_huts")));
        sounds.put(new ResourceLocation("undead", "mer_scre"), new SoundEvent(new ResourceLocation("undead", "mer_scre")));
        sounds.put(new ResourceLocation("undead", "rotten_attack"), new SoundEvent(new ResourceLocation("undead", "rotten_attack")));
        sounds.put(new ResourceLocation("undead", "thewolf_dies"), new SoundEvent(new ResourceLocation("undead", "thewolf_dies")));
        sounds.put(new ResourceLocation("undead", "the_wolf_ambiemt"), new SoundEvent(new ResourceLocation("undead", "the_wolf_ambiemt")));
        sounds.put(new ResourceLocation("undead", "the_wolf_hurts"), new SoundEvent(new ResourceLocation("undead", "the_wolf_hurts")));
        sounds.put(new ResourceLocation("undead", "the_wolf_attack"), new SoundEvent(new ResourceLocation("undead", "the_wolf_attack")));
        sounds.put(new ResourceLocation("undead", "chomper_dies"), new SoundEvent(new ResourceLocation("undead", "chomper_dies")));
        sounds.put(new ResourceLocation("undead", "chomper_bites"), new SoundEvent(new ResourceLocation("undead", "chomper_bites")));
        sounds.put(new ResourceLocation("undead", "icy_hound_ambient"), new SoundEvent(new ResourceLocation("undead", "icy_hound_ambient")));
        sounds.put(new ResourceLocation("undead", "icy_hound_attack"), new SoundEvent(new ResourceLocation("undead", "icy_hound_attack")));
        sounds.put(new ResourceLocation("undead", "screamer_cries"), new SoundEvent(new ResourceLocation("undead", "screamer_cries")));
        sounds.put(new ResourceLocation("undead", "party_sound"), new SoundEvent(new ResourceLocation("undead", "party_sound")));
        sounds.put(new ResourceLocation("undead", "ghost_2"), new SoundEvent(new ResourceLocation("undead", "ghost_2")));
        sounds.put(new ResourceLocation("undead", "ghost_1"), new SoundEvent(new ResourceLocation("undead", "ghost_1")));
        sounds.put(new ResourceLocation("undead", "crock_pot_shoots"), new SoundEvent(new ResourceLocation("undead", "crock_pot_shoots")));
        sounds.put(new ResourceLocation("undead", "soul_crock_pot_ambient"), new SoundEvent(new ResourceLocation("undead", "soul_crock_pot_ambient")));
        sounds.put(new ResourceLocation("undead", "crock_pot_hurts"), new SoundEvent(new ResourceLocation("undead", "crock_pot_hurts")));
        sounds.put(new ResourceLocation("undead", "blade_dancer_hurts"), new SoundEvent(new ResourceLocation("undead", "blade_dancer_hurts")));
        sounds.put(new ResourceLocation("undead", "dancr_laugh"), new SoundEvent(new ResourceLocation("undead", "dancr_laugh")));
        sounds.put(new ResourceLocation("undead", "dancer_dies"), new SoundEvent(new ResourceLocation("undead", "dancer_dies")));
        sounds.put(new ResourceLocation("undead", "hunter_breath"), new SoundEvent(new ResourceLocation("undead", "hunter_breath")));
        sounds.put(new ResourceLocation("undead", "hunter_dies"), new SoundEvent(new ResourceLocation("undead", "hunter_dies")));
        sounds.put(new ResourceLocation("undead", "hunter_new_die"), new SoundEvent(new ResourceLocation("undead", "hunter_new_die")));
        sounds.put(new ResourceLocation("undead", "new_hunter_breath"), new SoundEvent(new ResourceLocation("undead", "new_hunter_breath")));
        sounds.put(new ResourceLocation("undead", "bomber_new_bb"), new SoundEvent(new ResourceLocation("undead", "bomber_new_bb")));
        sounds.put(new ResourceLocation("undead", "bomber_new_ready"), new SoundEvent(new ResourceLocation("undead", "bomber_new_ready")));
        sounds.put(new ResourceLocation("undead", "glut_stop"), new SoundEvent(new ResourceLocation("undead", "glut_stop")));
        sounds.put(new ResourceLocation("undead", "misty_ambient"), new SoundEvent(new ResourceLocation("undead", "misty_ambient")));
        sounds.put(new ResourceLocation("undead", "bubby"), new SoundEvent(new ResourceLocation("undead", "bubby")));
        sounds.put(new ResourceLocation("undead", "mist_sung"), new SoundEvent(new ResourceLocation("undead", "mist_sung")));
        sounds.put(new ResourceLocation("undead", "dunnda"), new SoundEvent(new ResourceLocation("undead", "dunnda")));
        sounds.put(new ResourceLocation("undead", "melanholy_hurt"), new SoundEvent(new ResourceLocation("undead", "melanholy_hurt")));
        sounds.put(new ResourceLocation("undead", "melandholy_roar"), new SoundEvent(new ResourceLocation("undead", "melandholy_roar")));
        sounds.put(new ResourceLocation("undead", "mist_df"), new SoundEvent(new ResourceLocation("undead", "mist_df")));
        sounds.put(new ResourceLocation("undead", "bob_thrown"), new SoundEvent(new ResourceLocation("undead", "bob_thrown")));
        sounds.put(new ResourceLocation("undead", "waav_fdffff"), new SoundEvent(new ResourceLocation("undead", "waav_fdffff")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("undead").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        UndeadMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final UndeadModElements elements;
        protected final int sortid;

        public ModElement(UndeadModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

