/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.duck;

import com.mojang.logging.LogUtils;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import net.untitledduckmod.ModEntityTypes;
import net.untitledduckmod.ModItems;
import net.untitledduckmod.ModSoundEvents;
import net.untitledduckmod.duck.DuckCleanGoal;
import net.untitledduckmod.duck.DuckDiveGoal;
import net.untitledduckmod.duck.DuckSwimGoal;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DuckEntity
extends class_1429
implements IAnimatable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String EGG_LAY_TIME_TAG = "duckEggLayTime";
    public static final String VARIANT_TAG = "duckVariant";
    public static final String IS_FROM_SACK_TAG = "isFromSack";
    public static final float SWIM_SPEED_MULTIPLIER = 3.0f;
    protected static final class_2940<Byte> VARIANT = class_2945.method_12791(DuckEntity.class, (class_2941)class_2943.field_13319);
    protected static final class_2940<Byte> ANIMATION = class_2945.method_12791(DuckEntity.class, (class_2941)class_2943.field_13319);
    protected static final byte ANIMATION_IDLE = 0;
    protected static final byte ANIMATION_CLEAN = 1;
    protected static final byte ANIMATION_DIVE = 2;
    protected static final byte ANIMATION_DANCE = 3;
    protected static final byte ANIMATION_PANIC = 4;
    private static final AnimationBuilder WALK_ANIM = new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true));
    private static final AnimationBuilder IDLE_ANIM = new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_ANIM = new AnimationBuilder().addAnimation("swim", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_IDLE_ANIM = new AnimationBuilder().addAnimation("idle_swim", Boolean.valueOf(true));
    private static final AnimationBuilder CLEAN_ANIM = new AnimationBuilder().addAnimation("clean");
    private static final AnimationBuilder SWIM_CLEAN_ANIM = new AnimationBuilder().addAnimation("clean_swim");
    private static final AnimationBuilder DIVE_ANIM = new AnimationBuilder().addAnimation("dive");
    private static final AnimationBuilder DANCE_ANIM = new AnimationBuilder().addAnimation("dance", Boolean.valueOf(true));
    private static final AnimationBuilder FLY_ANIM = new AnimationBuilder().addAnimation("fly", Boolean.valueOf(true));
    private static final AnimationBuilder PANIC_ANIM = new AnimationBuilder().addAnimation("panic", Boolean.valueOf(true));
    private static final class_1856 BREEDING_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8317, class_1802.field_8188, class_1802.field_8706, class_1802.field_8309});
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int eggLayTime = this.field_5974.nextInt(6000) + 6000;
    private boolean isFlapping;
    private boolean wasSongPlaying = false;
    private boolean panicked = false;
    private boolean isFromSack = false;

    public DuckEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
    }

    public static class_5132.class_5133 getDefaultAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 7.0).method_26868(class_5134.field_23719, 0.2);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.setVariant((byte)this.field_5974.nextInt(2));
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(ANIMATION, (Object)0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10567(VARIANT_TAG, this.getVariant());
        tag.method_10569(EGG_LAY_TIME_TAG, this.eggLayTime);
        tag.method_10556(IS_FROM_SACK_TAG, this.isFromSack);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(tag.method_10571(VARIANT_TAG));
        if (tag.method_10545(EGG_LAY_TIME_TAG)) {
            this.eggLayTime = tag.method_10550(EGG_LAY_TIME_TAG);
        }
        this.setFromSack(tag.method_10577(IS_FROM_SACK_TAG));
    }

    public byte getVariant() {
        return (Byte)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(byte variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public byte getAnimation() {
        return (Byte)this.field_6011.method_12789(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.field_6011.method_12778(ANIMATION, (Object)animation);
    }

    public void method_6006(class_2338 songPosition, boolean playing) {
        if (playing && !this.wasSongPlaying) {
            this.setAnimation((byte)3);
            this.wasSongPlaying = true;
        } else if (!playing && this.wasSongPlaying) {
            this.setAnimation((byte)0);
            this.wasSongPlaying = false;
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new DuckSwimGoal((class_1314)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.6));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, BREEDING_INGREDIENT, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new DuckCleanGoal(this));
        this.field_6201.method_6277(5, (class_1352)new DuckDiveGoal(this));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    public boolean method_6481(class_1799 stack) {
        return BREEDING_INGREDIENT.method_8093(stack);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.field_6002.field_9236) {
            if (this.method_5805() && !this.method_6109() && --this.eggLayTime <= 0) {
                this.method_5783(ModSoundEvents.getDuckEggSound(), 1.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
                this.method_5706((class_1935)ModItems.getDuckEgg());
                this.eggLayTime = this.field_5974.nextInt(6000) + 6000;
            }
            class_243 velocity = this.method_18798();
            if (!this.field_5952 && velocity.field_1351 < 0.0) {
                this.method_18799(velocity.method_18805(1.0, 0.6, 1.0));
            }
            if (!this.panicked && this.method_6065() != null || this.method_5809()) {
                this.setAnimation((byte)4);
                this.panicked = true;
            } else if (this.panicked && this.method_6065() == null && !this.method_5809()) {
                this.setAnimation((byte)0);
                this.panicked = false;
            }
        }
        this.isFlapping = this.field_6002.field_9236 && !this.method_5799() && !this.field_5952;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_7909() == ModItems.getEmptyDuckSack()) {
            class_2487 duckData = new class_2487();
            if (this.method_5786(duckData)) {
                stackInHand.method_7934(1);
                class_1799 duckSack = new class_1799((class_1935)ModItems.getDuckSack());
                class_2487 sackData = new class_2487();
                sackData.method_10566("EntityTag", (class_2520)duckData);
                duckSack.method_7980(sackData);
                if (stackInHand.method_7960()) {
                    player.method_6122(hand, duckSack);
                } else if (!player.method_31548().method_7394(duckSack)) {
                    player.method_7328(duckSack, false);
                }
                this.field_6002.method_8396(null, this.method_24515(), ModSoundEvents.getDuckSackUse(), class_3419.field_15254, 1.0f, 1.0f);
            } else {
                LOGGER.error("Could not save duck data to duck sack!");
            }
            this.method_31472();
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5992(player, hand);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntityTypes.getDuck().method_5883((class_1937)world);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public boolean lookingAround() {
        return this.getAnimation() != 1;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.method_5799();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 1: {
                controller.setAnimation(inWater ? SWIM_CLEAN_ANIM : CLEAN_ANIM);
                break;
            }
            case 2: {
                controller.setAnimation(DIVE_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(DANCE_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void method_5966() {
        if (this.method_6109()) {
            this.method_5783(ModSoundEvents.getDucklingAmbientSound(), 0.3f, this.method_6017());
            return;
        }
        this.method_5783(ModSoundEvents.getDuckAmbientSound(), 0.1f, this.method_6017());
    }

    protected void method_6013(class_1282 source) {
        if (this.method_6109()) {
            this.method_5783(ModSoundEvents.getDucklingHurtSound(), 0.3f, this.method_6017() + 0.25f);
            return;
        }
        this.method_5783(ModSoundEvents.getDuckHurtSound(), 0.1f, this.method_6017() + 0.5f);
    }

    @Nullable
    protected class_3414 method_6002() {
        if (this.method_6109()) {
            return ModSoundEvents.getDucklingDeathSound();
        }
        return ModSoundEvents.getDuckDeathSound();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(ModSoundEvents.getDuckStepSound(), 0.15f, 1.0f);
    }

    protected void method_6010(class_6862<class_3611> fluid) {
        if (this.method_5942().method_6350()) {
            this.method_18799(this.method_18798().method_1031(0.0, (double)0.04f, 0.0));
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, 0.3, 0.0));
        }
    }

    public boolean method_17326() {
        return super.method_17326() || this.isFromSack;
    }

    public boolean isFromSack() {
        return this.isFromSack;
    }

    public void setFromSack(boolean fromSack) {
        this.isFromSack = fromSack;
    }
}

