/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.duck;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.untitledduckmod.ModEntityTypes;
import net.untitledduckmod.ModItems;
import net.untitledduckmod.ModSoundEvents;
import net.untitledduckmod.duck.DuckCleanGoal;
import net.untitledduckmod.duck.DuckDiveGoal;
import net.untitledduckmod.duck.DuckSwimGoal;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DuckEntity
extends Animal
implements IAnimatable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String EGG_LAY_TIME_TAG = "duckEggLayTime";
    public static final String VARIANT_TAG = "duckVariant";
    public static final String IS_FROM_SACK_TAG = "isFromSack";
    public static final float SWIM_SPEED_MULTIPLIER = 3.0f;
    protected static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(DuckEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(DuckEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final byte ANIMATION_IDLE = 0;
    protected static final byte ANIMATION_CLEAN = 1;
    protected static final byte ANIMATION_DIVE = 2;
    protected static final byte ANIMATION_DANCE = 3;
    protected static final byte ANIMATION_PANIC = 4;
    private static final AnimationBuilder WALK_ANIM = new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true));
    private static final AnimationBuilder IDLE_ANIM = new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_ANIM = new AnimationBuilder().addAnimation("swim", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_IDLE_ANIM = new AnimationBuilder().addAnimation("idle_swim", Boolean.valueOf(true));
    private static final AnimationBuilder CLEAN_ANIM = new AnimationBuilder().addAnimation("clean");
    private static final AnimationBuilder SWIM_CLEAN_ANIM = new AnimationBuilder().addAnimation("clean_swim");
    private static final AnimationBuilder DIVE_ANIM = new AnimationBuilder().addAnimation("dive");
    private static final AnimationBuilder DANCE_ANIM = new AnimationBuilder().addAnimation("dance", Boolean.valueOf(true));
    private static final AnimationBuilder FLY_ANIM = new AnimationBuilder().addAnimation("fly", Boolean.valueOf(true));
    private static final AnimationBuilder PANIC_ANIM = new AnimationBuilder().addAnimation("panic", Boolean.valueOf(true));
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_});
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int eggLayTime = this.f_19796_.nextInt(6000) + 6000;
    private boolean isFlapping;
    private boolean wasSongPlaying = false;
    private boolean panicked = false;
    private boolean isFromSack = false;

    public DuckEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.setVariant((byte)this.f_19796_.nextInt(2));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_(VARIANT_TAG, this.getVariant());
        tag.m_128405_(EGG_LAY_TIME_TAG, this.eggLayTime);
        tag.m_128379_(IS_FROM_SACK_TAG, this.isFromSack);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128445_(VARIANT_TAG));
        if (tag.m_128441_(EGG_LAY_TIME_TAG)) {
            this.eggLayTime = tag.m_128451_(EGG_LAY_TIME_TAG);
        }
        this.setFromSack(tag.m_128471_(IS_FROM_SACK_TAG));
    }

    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void m_6818_(BlockPos songPosition, boolean playing) {
        if (playing && !this.wasSongPlaying) {
            this.setAnimation((byte)3);
            this.wasSongPlaying = true;
        } else if (!playing && this.wasSongPlaying) {
            this.setAnimation((byte)0);
            this.wasSongPlaying = false;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DuckSwimGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, BREEDING_INGREDIENT, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DuckCleanGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new DuckDiveGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6898_(ItemStack stack) {
        return BREEDING_INGREDIENT.test(stack);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_6084_() && !this.m_6162_() && --this.eggLayTime <= 0) {
                this.m_5496_(ModSoundEvents.getDuckEggSound(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                this.m_19998_((ItemLike)ModItems.getDuckEgg());
                this.eggLayTime = this.f_19796_.nextInt(6000) + 6000;
            }
            Vec3 velocity = this.m_20184_();
            if (!this.f_19861_ && velocity.f_82480_ < 0.0) {
                this.m_20256_(velocity.m_82542_(1.0, 0.6, 1.0));
            }
            if (!this.panicked && this.m_142581_() != null || this.m_6060_()) {
                this.setAnimation((byte)4);
                this.panicked = true;
            } else if (this.panicked && this.m_142581_() == null && !this.m_6060_()) {
                this.setAnimation((byte)0);
                this.panicked = false;
            }
        }
        this.isFlapping = this.f_19853_.f_46443_ && !this.m_20069_() && !this.f_19861_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stackInHand = player.m_21120_(hand);
        if (stackInHand.m_41720_() == ModItems.getEmptyDuckSack()) {
            CompoundTag duckData = new CompoundTag();
            if (this.m_20086_(duckData)) {
                stackInHand.m_41774_(1);
                ItemStack duckSack = new ItemStack((ItemLike)ModItems.getDuckSack());
                CompoundTag sackData = new CompoundTag();
                sackData.m_128365_("EntityTag", (Tag)duckData);
                duckSack.m_41751_(sackData);
                if (stackInHand.m_41619_()) {
                    player.m_21008_(hand, duckSack);
                } else if (!player.m_150109_().m_36054_(duckSack)) {
                    player.m_36176_(duckSack, false);
                }
                this.f_19853_.m_5594_(null, this.m_142538_(), ModSoundEvents.getDuckSackUse(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                LOGGER.error("Could not save duck data to duck sack!");
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)ModEntityTypes.getDuck().m_20615_((Level)world);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public boolean lookingAround() {
        return this.getAnimation() != 1;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.m_20069_();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 1: {
                controller.setAnimation(inWater ? SWIM_CLEAN_ANIM : CLEAN_ANIM);
                break;
            }
            case 2: {
                controller.setAnimation(DIVE_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(DANCE_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_8032_() {
        if (this.m_6162_()) {
            this.m_5496_(ModSoundEvents.getDucklingAmbientSound(), 0.3f, this.m_6100_());
            return;
        }
        this.m_5496_(ModSoundEvents.getDuckAmbientSound(), 0.1f, this.m_6100_());
    }

    protected void m_6677_(DamageSource source) {
        if (this.m_6162_()) {
            this.m_5496_(ModSoundEvents.getDucklingHurtSound(), 0.3f, this.m_6100_() + 0.25f);
            return;
        }
        this.m_5496_(ModSoundEvents.getDuckHurtSound(), 0.1f, this.m_6100_() + 0.5f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        if (this.m_6162_()) {
            return ModSoundEvents.getDucklingDeathSound();
        }
        return ModSoundEvents.getDuckDeathSound();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(ModSoundEvents.getDuckStepSound(), 0.15f, 1.0f);
    }

    protected void m_203347_(TagKey<Fluid> fluid) {
        if (this.m_21573_().m_26576_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.04f, 0.0));
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3, 0.0));
        }
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.isFromSack;
    }

    public boolean isFromSack() {
        return this.isFromSack;
    }

    public void setFromSack(boolean fromSack) {
        this.isFromSack = fromSack;
    }
}

