/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.forge;

import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.untitledduckmod.ModConfig;
import net.untitledduckmod.duck.DuckEntity;
import net.untitledduckmod.goose.GooseEntity;
import net.untitledduckmod.items.DuckEggEntity;
import net.untitledduckmod.registration.EntityTypeBuilders;

public class ModEntityTypesImpl {
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"untitledduckmod");
    public static final RegistryObject<EntityType<DuckEntity>> DUCK = ENTITIES.register("duck", EntityTypeBuilders.DUCK);
    public static final RegistryObject<EntityType<DuckEggEntity>> DUCK_EGG = ENTITIES.register("duck_egg", EntityTypeBuilders.DUCK_EGG);
    public static final RegistryObject<EntityType<GooseEntity>> GOOSE = ENTITIES.register("goose", EntityTypeBuilders.GOOSE);
    public static final RegistryObject<EntityType<DuckEggEntity>> GOOSE_EGG = ENTITIES.register("goose_egg", EntityTypeBuilders.GOOSE_EGG);

    public static void register(Object optionalEvent) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ENTITIES.register(bus);
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DUCK.get(), DuckEntity.getDefaultAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_());
        event.put((EntityType)GOOSE.get(), GooseEntity.getDefaultAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_());
    }

    public static void setupSpawning() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)DUCK.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)GOOSE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        MinecraftForge.EVENT_BUS.addListener(ModEntityTypesImpl::onBiomeLoading);
    }

    private static void onBiomeLoading(BiomeLoadingEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getName() == null) {
            return;
        }
        List spawner = event.getSpawns().getSpawner(MobCategory.CREATURE);
        spawner.add(new MobSpawnSettings.SpawnerData((EntityType)DUCK.get(), ModConfig.Duck.WEIGHT.get().intValue(), ModConfig.Duck.GROUP_SIZE.get().intValue(), ModConfig.Duck.GROUP_SIZE.get().intValue()));
        spawner.add(new MobSpawnSettings.SpawnerData((EntityType)GOOSE.get(), ModConfig.Goose.WEIGHT.get().intValue(), ModConfig.Goose.GROUP_SIZE.get().intValue(), ModConfig.Goose.GROUP_SIZE.get().intValue()));
    }

    public static EntityType<DuckEntity> getDuck() {
        return (EntityType)DUCK.get();
    }

    public static EntityType<DuckEggEntity> getDuckEgg() {
        return (EntityType)DUCK_EGG.get();
    }

    public static EntityType<GooseEntity> getGoose() {
        return (EntityType)GOOSE.get();
    }

    public static EntityType<DuckEggEntity> getGooseEgg() {
        return (EntityType)GOOSE_EGG.get();
    }
}

