/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.forge.duck;

import net.minecraft.resources.ResourceLocation;
import net.untitledduckmod.duck.DuckEntity;
import net.untitledduckmod.duck.DuckModelIdentifiers;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class DuckModel
extends AnimatedGeoModel<DuckEntity> {
    private ResourceLocation currentTexture = DuckModelIdentifiers.NORMAL_TEXTURE;

    public ResourceLocation getModelLocation(DuckEntity object) {
        return DuckModelIdentifiers.DUCK_MODEL_LOCATION;
    }

    public ResourceLocation getTextureLocation(DuckEntity object) {
        return this.currentTexture;
    }

    public ResourceLocation getAnimationFileLocation(DuckEntity animatable) {
        return DuckModelIdentifiers.DUCK_ANIMATION_FILE_LOCATION;
    }

    public void setLivingAnimations(DuckEntity entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        if (entity.m_6162_()) {
            IBone root = this.getAnimationProcessor().getBone("root");
            root.setScaleX(0.7f);
            root.setScaleY(0.7f);
            root.setScaleZ(0.7f);
            this.currentTexture = DuckModelIdentifiers.DUCKLING_TEXTURE;
        } else {
            this.currentTexture = entity.getVariant() == 0 ? DuckModelIdentifiers.NORMAL_TEXTURE : DuckModelIdentifiers.FEMALE_TEXTURE;
        }
        IBone head = this.getAnimationProcessor().getBone("head");
        if (entity.lookingAround() && head != null) {
            EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

