/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.forge;

import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.untitledduckmod.duck.DuckEntity;
import net.untitledduckmod.forge.duck.DuckEntityForge;
import net.untitledduckmod.forge.goose.GooseEntityForge;
import net.untitledduckmod.goose.GooseEntity;
import net.untitledduckmod.items.DuckEggEntity;
import net.untitledduckmod.registration.EntityTypeBuilders;

public class ModEntityTypesImpl {
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"untitledduckmod");
    public static final Supplier<EntityType<DuckEntityForge>> DUCK_FORGE_BUILDER = () -> EntityTypeBuilders.build("duck", EntityType.Builder.m_20704_(DuckEntityForge::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 0.6f).m_20702_(10));
    public static final Supplier<EntityType<GooseEntityForge>> GOOSE_FORGE_BUILDER = () -> EntityTypeBuilders.build("goose", EntityType.Builder.m_20704_(GooseEntityForge::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.7f, 1.2f).m_20702_(10));
    public static final RegistryObject<EntityType<DuckEntityForge>> DUCK = ENTITIES.register("duck", DUCK_FORGE_BUILDER);
    public static final RegistryObject<EntityType<DuckEggEntity>> DUCK_EGG = ENTITIES.register("duck_egg", EntityTypeBuilders.DUCK_EGG);
    public static final RegistryObject<EntityType<GooseEntityForge>> GOOSE = ENTITIES.register("goose", GOOSE_FORGE_BUILDER);
    public static final RegistryObject<EntityType<DuckEggEntity>> GOOSE_EGG = ENTITIES.register("goose_egg", EntityTypeBuilders.GOOSE_EGG);

    public static void register(Object optionalEvent) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ENTITIES.register(bus);
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DUCK.get(), DuckEntity.getDefaultAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_());
        event.put((EntityType)GOOSE.get(), GooseEntity.getDefaultAttributes().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_());
    }

    public static void setupSpawning() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)DUCK.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (a, b, c, d, e) -> true);
        SpawnPlacements.m_21754_((EntityType)((EntityType)GOOSE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (a, b, c, d, e) -> true);
    }

    public static EntityType<DuckEntityForge> getDuck() {
        return (EntityType)DUCK.get();
    }

    public static EntityType<DuckEggEntity> getDuckEgg() {
        return (EntityType)DUCK_EGG.get();
    }

    public static EntityType<GooseEntityForge> getGoose() {
        return (EntityType)GOOSE.get();
    }

    public static EntityType<DuckEggEntity> getGooseEgg() {
        return (EntityType)GOOSE_EGG.get();
    }
}

