/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.goose;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.untitledduckmod.ModEntityTypes;
import net.untitledduckmod.ModItems;
import net.untitledduckmod.ModSoundEvents;
import net.untitledduckmod.duck.DuckSwimGoal;
import net.untitledduckmod.goose.GooseCleanGoal;
import net.untitledduckmod.goose.GooseEatGoal;
import net.untitledduckmod.goose.GooseEscapeDangerGoal;
import net.untitledduckmod.goose.GooseIntimidateMobsGoal;
import net.untitledduckmod.goose.GooseMeleeAttackGoal;
import net.untitledduckmod.goose.GoosePickupFoodGoal;
import net.untitledduckmod.goose.GooseRevengeGoal;
import net.untitledduckmod.goose.GooseStealItemGoal;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.ParticleKeyFrameEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GooseEntity
extends TamableAnimal
implements IAnimatable,
NeutralMob,
AnimationController.IParticleListener {
    public static final String EGG_LAY_TIME_TAG = "gooseEggLayTime";
    public static final String VARIANT_TAG = "gooseVariant";
    public static final float SWIM_SPEED_MULTIPLIER = 3.0f;
    protected static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(GooseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(GooseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(GooseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_TIME_RANGE = UniformInt.m_146622_((int)20, (int)39);
    private UUID targetUuid;
    public static final byte ANIMATION_IDLE = 0;
    public static final byte ANIMATION_CLEAN = 1;
    public static final byte ANIMATION_BITE = 2;
    public static final int ANIMATION_BITE_LEN = 22;
    public static final byte ANIMATION_DANCE = 3;
    public static final byte ANIMATION_PANIC = 4;
    public static final byte ANIMATION_EAT = 5;
    public static final byte ANIMATION_INTIMIDATE = 6;
    private static final AnimationBuilder WALK_ANIM = new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true));
    private static final AnimationBuilder IDLE_ANIM = new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_ANIM = new AnimationBuilder().addAnimation("swim", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_IDLE_ANIM = new AnimationBuilder().addAnimation("idle_swim", Boolean.valueOf(true));
    private static final AnimationBuilder PANIC_ANIM = new AnimationBuilder().addAnimation("panic", Boolean.valueOf(true));
    private static final AnimationBuilder FLY_ANIM = new AnimationBuilder().addAnimation("fly", Boolean.valueOf(true));
    private static final AnimationBuilder CLEAN_ANIM = new AnimationBuilder().addAnimation("clean");
    private static final AnimationBuilder EAT_ANIM = new AnimationBuilder().addAnimation("eat", Boolean.valueOf(true));
    private static final AnimationBuilder INTIMIDATE_ANIM = new AnimationBuilder().addAnimation("intimidate", Boolean.valueOf(true));
    private static final AnimationBuilder HONK_ANIM = new AnimationBuilder().addAnimation("honk", Boolean.valueOf(true));
    private static final AnimationBuilder BITE_ANIM = new AnimationBuilder().addAnimation("bite", Boolean.valueOf(true));
    private static final AnimationBuilder SIT_ANIM = new AnimationBuilder().addAnimation("sit", Boolean.valueOf(true));
    private static final AnimationBuilder CHARGE_ANIM = new AnimationBuilder().addAnimation("charge", Boolean.valueOf(true));
    public static final Ingredient FOOD = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_, Items.f_41910_, Items.f_41867_});
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_});
    private static final Ingredient TAMING_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41910_, Items.f_41867_});
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int eggLayTime = this.f_19796_.m_188503_(6000) + 6000;
    private boolean isFlapping;
    private boolean wasSongPlaying = false;
    private boolean panicked = false;
    private int animationTimer = 0;

    public GooseEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21553_(true);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.setVariant((byte)this.f_19796_.m_188503_(2));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(7.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_(VARIANT_TAG, this.getVariant());
        tag.m_128405_(EGG_LAY_TIME_TAG, this.eggLayTime);
        this.m_21678_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128445_(VARIANT_TAG));
        if (tag.m_128441_(EGG_LAY_TIME_TAG)) {
            this.eggLayTime = tag.m_128451_(EGG_LAY_TIME_TAG);
        }
        this.m_147285_(this.f_19853_, tag);
    }

    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void m_6818_(BlockPos songPosition, boolean playing) {
        if (playing && !this.wasSongPlaying) {
            this.setAnimation((byte)3);
            this.wasSongPlaying = true;
        } else if (!playing && this.wasSongPlaying) {
            this.setAnimation((byte)0);
            this.wasSongPlaying = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte status) {
        if (status == 100) {
            SimpleParticleType particleEffect = ParticleTypes.f_123748_;
            for (int i = 0; i < 7; ++i) {
                double d = this.f_19796_.m_188583_() * 0.02;
                double e = this.f_19796_.m_188583_() * 0.02;
                double f = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)particleEffect, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
            }
        }
        super.m_7822_(status);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DuckSwimGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new GooseEscapeDangerGoal((PathfinderMob)this, 1.7));
        this.f_21345_.m_25352_(2, (Goal)new GooseIntimidateMobsGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new GooseEatGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new GooseStealItemGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new GoosePickupFoodGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new GooseMeleeAttackGoal(this, 1.5, true));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, BREEDING_INGREDIENT, false));
        this.f_21345_.m_25352_(8, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(9, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.6, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(9, (Goal)new GooseCleanGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new GooseRevengeGoal(this).m_26044_(new Class[0]));
    }

    public boolean m_6898_(ItemStack stack) {
        return !this.isAngry() && BREEDING_INGREDIENT.test(stack);
    }

    public void m_238392_(EquipmentSlot slot, ItemStack oldStack, ItemStack newStack) {
        ItemEntity ie;
        UUID thrower;
        if (this.f_19853_.f_46443_) {
            return;
        }
        Entity holder = newStack.m_41609_();
        if (this.isAngry() && holder instanceof ItemEntity && (thrower = (ie = (ItemEntity)holder).m_32057_()) != null) {
            this.m_21662_();
        }
        super.m_238392_(slot, oldStack, newStack);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_6084_() && !this.m_6162_() && --this.eggLayTime <= 0) {
                this.m_5496_(ModSoundEvents.getGooseEggSound(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19998_((ItemLike)ModItems.getGooseEgg());
                this.eggLayTime = this.f_19796_.m_188503_(6000) + 6000;
            }
            Vec3 velocity = this.m_20184_();
            if (!this.f_19861_ && velocity.f_82480_ < 0.0) {
                this.m_20256_(velocity.m_82542_(1.0, 0.6, 1.0));
            }
            if (!this.panicked && (this.m_21223_() < this.m_21233_() / 2.0f || this.m_6162_()) && (this.m_21188_() != null || this.m_6060_())) {
                this.setAnimation((byte)4);
                this.panicked = true;
            } else if (this.panicked && this.m_21188_() == null && !this.m_6060_()) {
                this.setAnimation((byte)0);
                this.panicked = false;
            }
            if (this.animationTimer > 0) {
                --this.animationTimer;
                if (this.animationTimer == 0) {
                    this.setAnimation((byte)0);
                }
            }
        }
        this.isFlapping = this.f_19853_.f_46443_ && !this.m_20069_() && !this.f_19861_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.f_19853_.f_46443_) {
            boolean tamable = this.m_21830_((LivingEntity)player) || this.m_21824_() || TAMING_INGREDIENT.test(itemStack) && !this.m_21824_() && !this.m_21660_();
            return tamable ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            InteractionResult actionResult = super.m_6071_(player, hand);
            if ((!actionResult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(player, hand);
        }
        if (this.isAngry()) {
            if (FOOD.test(itemStack)) {
                ItemStack newStack = itemStack.m_41777_();
                newStack.m_41764_(1);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                if (this.m_21540_(newStack)) {
                    this.m_21662_();
                }
            }
            return InteractionResult.CONSUME;
        }
        if (TAMING_INGREDIENT.test(itemStack)) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private boolean isAngry() {
        return this.m_5448_() != null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.m_21839_(false);
        return super.m_6469_(source, amount);
    }

    protected void m_7581_(ItemEntity item) {
        if (this.m_6162_()) {
            return;
        }
        if (item.m_32057_() == this.m_20148_()) {
            return;
        }
        super.m_7581_(item);
    }

    public void m_21662_() {
        this.m_6703_(null);
        this.m_6925_(null);
        this.m_6710_(null);
        this.m_7870_(0);
        this.f_19853_.m_7605_((Entity)this, (byte)100);
    }

    public boolean m_21540_(ItemStack equipment) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        ItemStack itemStack = this.m_21205_();
        if (FOOD.test(equipment) || this.m_7252_(equipment)) {
            ItemEntity itemEntity;
            if (!itemStack.m_41619_() && (itemEntity = this.m_19983_(itemStack)) != null) {
                itemEntity.m_32010_(60);
            }
            this.m_21468_(equipmentSlot, equipment);
            return true;
        }
        return false;
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack mainHandStack = this.m_21205_();
        if (!FOOD.test(mainHandStack) && FOOD.test(stack)) {
            return true;
        }
        if (mainHandStack.m_41619_()) {
            return stack.m_41720_() != ModItems.getGooseEgg();
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)ModEntityTypes.getGoose().m_20615_((Level)world);
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate);
        controller.registerParticleListener((AnimationController.IParticleListener)this);
        data.addAnimationController(controller);
    }

    public boolean lookingAround() {
        return this.getAnimation() != 1 || this.getAnimation() != 5;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.m_20069_();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            controller.setAnimation(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 2: {
                controller.setAnimation(BITE_ANIM);
                this.animationTimer = 22;
                break;
            }
            case 6: {
                controller.setAnimation(INTIMIDATE_ANIM);
                break;
            }
            case 5: {
                controller.setAnimation(EAT_ANIM);
                break;
            }
            case 1: {
                controller.setAnimation(inWater ? SWIM_ANIM : CLEAN_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(HONK_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                if (this.m_5912_()) {
                    controller.setAnimation(CHARGE_ANIM);
                    return PlayState.CONTINUE;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void tryEating() {
        assert (!this.f_19853_.m_5776_());
        ItemStack stack = this.m_21205_();
        stack.m_41774_(1);
        this.m_5496_(this.m_7866_(stack), 0.5f + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        if (stack.m_41619_()) {
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if (this.isHungry()) {
            this.m_5634_(0.5f);
        }
    }

    public void m_8032_() {
        if (this.m_6162_()) {
            this.m_5496_(ModSoundEvents.getDucklingAmbientSound(), 0.3f, this.m_6100_());
            return;
        }
        if (this.m_21660_()) {
            this.m_5496_(ModSoundEvents.getGooseHonkSound(), 0.6f, this.m_6100_());
        }
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack stack, float yOffset) {
        ItemEntity droppedStack = super.m_5552_(stack, yOffset);
        if (droppedStack == null) {
            return null;
        }
        droppedStack.m_32052_(this.m_20148_());
        return droppedStack;
    }

    protected void m_6677_(DamageSource source) {
        if (this.m_6162_()) {
            this.m_5496_(ModSoundEvents.getGoslingHurtSound(), 0.3f, this.m_6100_() + 0.25f);
            return;
        }
        this.m_5496_(ModSoundEvents.getGooseHonkSound(), 0.7f, this.m_6100_());
    }

    @Nullable
    protected SoundEvent m_5592_() {
        if (this.m_6162_()) {
            return ModSoundEvents.getGoslingDeathSound();
        }
        return ModSoundEvents.getGooseDeathSound();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(ModSoundEvents.getDuckStepSound(), 0.15f, 1.0f);
    }

    protected void m_203347_(TagKey<Fluid> fluid) {
        if (this.m_21573_().m_26576_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.04f, 0.0));
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3, 0.0));
        }
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int ticks) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)ticks);
    }

    @Nullable
    public UUID m_6120_() {
        return this.targetUuid;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    public void summonParticle(ParticleKeyFrameEvent particleKeyFrameEvent) {
        ItemStack stack = this.m_21205_();
        if (stack == ItemStack.f_41583_) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Vec3 vel = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vel = vel.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vel = vel.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            Vec3 rotationVec = Vec3.m_82498_((float)0.0f, (float)this.f_20883_);
            Vec3 pos = new Vec3(this.m_20185_() + rotationVec.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + rotationVec.f_82481_ / 2.0);
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_ + 0.05, vel.f_82481_);
        }
    }

    public boolean wantsToPickupItem() {
        return !this.m_21827_();
    }

    public boolean isHungry() {
        return this.isAngry() || this.m_21223_() <= this.m_21233_() - 0.5f;
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }
}

