/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.RawAnimation;

public abstract class WaterfowlEntity
extends TamableAnimal
implements GeoAnimatable {
    public static final String EGG_LAY_TIME_TAG = "EggLayTime";
    public static final String VARIANT_TAG = "Variant";
    public static final float SWIM_SPEED_MULTIPLIER = 3.0f;
    protected static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.defineId(WaterfowlEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.defineId(WaterfowlEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final byte ANIMATION_IDLE = 0;
    public static final byte ANIMATION_CLEAN = 1;
    public static final byte ANIMATION_DANCE = 3;
    public static final byte ANIMATION_PANIC = 4;
    public static final byte ANIMATION_EAT = 5;
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenPlay("walk");
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation SWIM_ANIM = RawAnimation.begin().thenPlay("swim");
    protected static final RawAnimation SWIM_IDLE_ANIM = RawAnimation.begin().thenPlay("idle_swim");
    protected static final RawAnimation PANIC_ANIM = RawAnimation.begin().thenPlay("panic");
    protected static final RawAnimation FLY_ANIM = RawAnimation.begin().thenPlay("fly");
    protected static final RawAnimation CLEAN_ANIM = RawAnimation.begin().thenPlay("clean");
    protected static final RawAnimation EAT_ANIM = RawAnimation.begin().thenPlay("eat");
    protected static final RawAnimation SIT_ANIM = RawAnimation.begin().thenPlay("sit");
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    protected int eggLayTime = this.random.nextInt(6000) + 6000;
    protected boolean isFlapping;
    protected boolean panicked = false;

    protected WaterfowlEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setVariant((byte)this.level().getRandom().nextInt(2));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(ANIMATION, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte(VARIANT_TAG, this.getVariant());
        tag.putInt(EGG_LAY_TIME_TAG, this.eggLayTime);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(tag.getByte(VARIANT_TAG));
        if (tag.contains(EGG_LAY_TIME_TAG)) {
            this.eggLayTime = tag.getInt(EGG_LAY_TIME_TAG);
        }
    }

    public void setTame(boolean tamed, boolean updateAttributes) {
        super.setTame(tamed, updateAttributes);
        if (tamed) {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(20.0);
            this.setHealth(20.0f);
        } else {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(7.0);
        }
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public byte getVariant() {
        return (Byte)this.entityData.get(VARIANT);
    }

    public void setVariant(byte variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public byte getAnimation() {
        return (Byte)this.entityData.get(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public boolean isHungry() {
        return this.getHealth() <= this.getMaxHealth() - 0.5f;
    }

    public void tryEating() {
        assert (!this.level().isClientSide());
        ItemStack stack = this.getMainHandItem();
        stack.shrink(1);
        this.playSound(this.getEatingSound(stack), 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        if (stack.isEmpty()) {
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        if (this.isHungry()) {
            this.heal(0.5f);
        }
    }

    public boolean lookingAround() {
        return this.getAnimation() != 1 || this.getAnimation() != 5;
    }

    protected abstract SoundEvent getLayEggSound();

    public abstract Item getEggItem();

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            if (this.isAlive() && !this.isBaby() && --this.eggLayTime <= 0) {
                this.playSound(this.getLayEggSound(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.spawnAtLocation((ItemLike)this.getEggItem());
                this.eggLayTime = this.random.nextInt(6000) + 6000;
            }
            Vec3 velocity = this.getDeltaMovement();
            if (!this.onGround() && velocity.y < 0.0) {
                this.setDeltaMovement(velocity.multiply(1.0, 0.6, 1.0));
            }
            this.handlePanicAnimation();
        }
        this.isFlapping = this.level().isClientSide && !this.isInWater() && !this.onGround();
    }

    protected abstract void handlePanicAnimation();

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(!this.level().isClientSide || this.isBaby() && this.isFood(stack))) {
            if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            return !this.isTamableItem(stack) || !(this.getHealth() < this.getMaxHealth()) && this.isTame() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            if (this.isFood(stack) && this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(player, hand, stack);
                this.heal(0.5f);
                return InteractionResult.CONSUME;
            }
            InteractionResult actionResult = super.mobInteract(player, hand);
            if (!actionResult.consumesAction() || this.isBaby()) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
            }
            return actionResult;
        }
        if (this.tryTaming(player, stack)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (this.random.nextInt(3) == 0) {
                this.tame(player);
                this.navigation.stop();
                this.setTarget(null);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    protected boolean tryTaming(Player player, ItemStack stack) {
        return this.isTamable(player, stack);
    }

    protected abstract boolean isTamableItem(ItemStack var1);

    protected boolean isTamable(Player player, ItemStack stack) {
        return this.isTamableItem(stack) && !this.isTame();
    }

    protected void jumpInLiquid(TagKey<Fluid> fluid) {
        if (this.getNavigation().canFloat()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.04f, 0.0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean hurt(DamageSource source, float amount) {
        this.setOrderedToSit(false);
        return super.hurt(source, amount);
    }

    public double getTick(Object o) {
        return this.tickCount;
    }

    public int getEggLayTime() {
        return this.eggLayTime;
    }
}

