/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.init.neoforge;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.untitledduckmod.DuckMod;
import net.untitledduckmod.common.init.neoforge.ModEntityTypesImpl;
import net.untitledduckmod.common.platform.neoforge.RegistryHelperImpl;

public class ModBiomeModifier
implements BiomeModifier {
    private static final String BIOME_MODIFIER_NAME = "untitled_spawns";
    private static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<ModBiomeModifier>> SERIALIZER = DeferredHolder.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (ResourceLocation)DuckMod.id("untitled_spawns"));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            ModEntityTypesImpl.addBiomeSpawns(biome, builder);
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)SERIALIZER.get();
    }

    public static MapCodec<ModBiomeModifier> makeCodec() {
        return MapCodec.unit(ModBiomeModifier::new);
    }

    public static void init() {
        RegistryHelperImpl.registerBiomeModifier(BIOME_MODIFIER_NAME, ModBiomeModifier::makeCodec);
    }
}

