/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.mixin;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.untitledduckmod.common.entity.WaterfowlEggEntity;
import net.untitledduckmod.common.init.ModEntityTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class DuckEggSpawnMixin {
    @Shadow
    private ClientLevel level;

    @Inject(method={"handleAddEntity(Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;)V"}, at={@At(value="TAIL")})
    public void spawnDuckEgg(ClientboundAddEntityPacket packet, CallbackInfo info) {
        EntityType<? extends ThrowableItemProjectile> entityType = DuckEggSpawnMixin.untitledduckmod$convert(packet.getType());
        if (entityType != null) {
            double x = packet.getX();
            double y = packet.getY();
            double z = packet.getZ();
            WaterfowlEggEntity entity = new WaterfowlEggEntity(entityType, (Level)this.level, x, y, z);
            entity.syncPacketPositionCodec(x, y, z);
            entity.moveTo(x, y, z);
            entity.setXRot(packet.getXRot() * 360.0f / 256.0f);
            entity.setYRot(packet.getYRot() * 360.0f / 256.0f);
            int id = packet.getId();
            entity.setId(id);
            entity.setUUID(packet.getUUID());
            this.level.addEntity((Entity)entity);
        }
    }

    @Unique
    private static EntityType<? extends ThrowableItemProjectile> untitledduckmod$convert(EntityType<?> entityType) {
        if (entityType == ModEntityTypes.getDuckEgg()) {
            return ModEntityTypes.getDuckEgg();
        }
        if (entityType == ModEntityTypes.getGooseEgg()) {
            return ModEntityTypes.getGooseEgg();
        }
        return null;
    }
}

