/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_39;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_5716;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_8514;
import net.minecraft.class_8567;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import net.untitledduckmod.common.config.UntitledConfig;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import net.untitledduckmod.common.entity.ai.goal.common.EatGoal;
import net.untitledduckmod.common.entity.ai.goal.common.SwimGoal;
import net.untitledduckmod.common.entity.ai.goal.common.WFollowOwnerGoal;
import net.untitledduckmod.common.entity.ai.goal.common.WFollowParentGoal;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModItems;
import net.untitledduckmod.common.init.ModSoundEvents;
import net.untitledduckmod.common.init.ModTags;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DuckEntity
extends WaterfowlEntity
implements class_8514,
AnimationController.ParticleKeyframeHandler<DuckEntity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String IS_FROM_SACK_TAG = "isFromSack";
    private static final class_2940<Boolean> DANCING = class_2945.method_12791(DuckEntity.class, (class_2941)class_2943.field_13323);
    public static final byte ANIMATION_DIVE = 2;
    private static final RawAnimation SWIM_CLEAN_ANIM = RawAnimation.begin().thenPlay("clean_swim").thenPlay("idle_swim");
    private static final RawAnimation DIVE_ANIM = RawAnimation.begin().thenPlay("dive").thenPlay("idle_swim");
    private static final RawAnimation DANCE_ANIM = RawAnimation.begin().thenPlay("dance");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isFromSack = false;
    @Nullable
    private class_2338 jukeboxPos;
    private class_8514.class_8515 vibrationListenerData;
    private final class_8514.class_5719 vibrationCallback = new VibrationCallback();
    private final class_5715<JukeboxEventListener> jukeboxEventHandler;

    public DuckEntity(class_1299<? extends WaterfowlEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.vibrationListenerData = new class_8514.class_8515();
        this.jukeboxEventHandler = new class_5715((class_5714)new JukeboxEventListener(this.vibrationCallback.method_51300(), ((class_5712)class_5712.field_39485.comp_349()).comp_2193()));
    }

    public static class_5132.class_5133 getDefaultAttributes() {
        return WaterfowlEntity.method_61457().method_26868(class_5134.field_23716, 7.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23726, 2.0);
    }

    @Override
    public void method_6173(boolean tamed, boolean updateAttributes) {
        super.method_6173(tamed, updateAttributes);
        Objects.requireNonNull(this.method_5996(class_5134.field_23726)).method_6192(2.0);
    }

    public static boolean checkDuckSpawnRules(class_1299<DuckEntity> duck, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(ModTags.BlockTags.DUCKS_SPAWNABLE_ON) || world.method_8320(pos.method_10074()).method_26227().method_15767(class_3486.field_15517);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DANCING, (Object)false);
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556(IS_FROM_SACK_TAG, this.isFromSack);
        DataResult result = class_8514.class_8515.field_44640.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.vibrationListenerData);
        result.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(nbtElement -> tag.method_10566("listener", nbtElement));
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setFromSack(tag.method_10577(IS_FROM_SACK_TAG));
        if (tag.method_10573("listener", 10)) {
            DataResult result = class_8514.class_8515.field_44640.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("listener")));
            result.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(listenerData -> {
                this.vibrationListenerData = listenerData;
            });
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            class_8514.class_8517.method_51406((class_1937)this.method_37908(), (class_8514.class_8515)this.vibrationListenerData, (class_8514.class_5719)this.vibrationCallback);
        }
    }

    public void method_6006(class_2338 jukeboxPos, boolean playing) {
        if (playing) {
            if (!this.isDancing()) {
                this.jukeboxPos = jukeboxPos;
                this.setDancing(true);
            }
        } else if (jukeboxPos.equals((Object)this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDancing(false);
        }
    }

    public boolean isDancing() {
        return (Boolean)this.field_6011.method_12789(DANCING);
    }

    public void setDancing(boolean dancing) {
        if (!(this.method_37908().field_9236 || !this.method_6034() || dancing && this.panicked)) {
            if (dancing) {
                this.setAnimation((byte)3);
            } else {
                this.setAnimation((byte)0);
            }
            this.field_6011.method_12778(DANCING, (Object)dancing);
        }
    }

    private boolean shouldStopDancing() {
        return this.jukeboxPos == null || !this.jukeboxPos.method_19769((class_2374)this.method_19538(), (double)((class_5712)class_5712.field_39485.comp_349()).comp_2193()) || !this.method_37908().method_8320(this.jukeboxPos).method_27852(class_2246.field_10223) || this.panicked;
    }

    public class_8514.class_8515 method_51298() {
        return this.vibrationListenerData;
    }

    public class_8514.class_5719 method_51299() {
        return this.vibrationCallback;
    }

    public void method_42147(BiConsumer<class_5715<?>, class_3218> callback) {
        class_1937 world = this.method_37908();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            callback.accept(this.jukeboxEventHandler, serverWorld);
        }
    }

    public static class_1856 getFoodIngredient() {
        return class_1856.method_8106((class_6885)class_7923.field_41178.method_46735(ModTags.ItemTags.DUCK_FOOD));
    }

    public static class_1856 getBreedingIngredient() {
        return class_1856.method_8106((class_6885)class_7923.field_41178.method_46735(ModTags.ItemTags.DUCK_BREEDING_FOOD));
    }

    public static class_1856 getTamingIngredient() {
        return class_1856.method_8106((class_6885)class_7923.field_41178.method_46735(ModTags.ItemTags.DUCK_TAMING_FOOD));
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SwimGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.6));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new EatGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.0, (Predicate)DuckEntity.getBreedingIngredient(), false));
        this.field_6201.method_6277(5, (class_1352)new WFollowParentGoal(this, 1.1));
        this.field_6201.method_6277(6, (class_1352)new WFollowOwnerGoal(this, 1.6, 10.0f, 2.0f));
        this.field_6201.method_6277(6, (class_1352)new CleanGoal(this));
        this.field_6201.method_6277(6, (class_1352)new DiveGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public boolean method_6481(class_1799 stack) {
        if (this.method_6181()) {
            return DuckEntity.getTamingIngredient().method_8093(stack) || DuckEntity.getBreedingIngredient().method_8093(stack);
        }
        return DuckEntity.getBreedingIngredient().method_8093(stack);
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236 && this.isDancing() && this.shouldStopDancing() && this.field_6012 % 20 == 0) {
            this.setDancing(false);
            this.jukeboxPos = null;
        }
    }

    @Override
    protected void handlePanicAnimation() {
        if (!this.panicked && this.method_6065() != null || this.method_5809()) {
            this.setAnimation((byte)4);
            this.panicked = true;
        } else if (this.panicked && this.method_6065() == null && !this.method_5809()) {
            this.setAnimation((byte)0);
            this.panicked = false;
        }
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_7909() == ModItems.EMPTY_DUCK_SACK.get()) {
            class_2487 duckData = new class_2487();
            if (this.method_5786(duckData)) {
                stackInHand.method_57008(1, (class_1309)player);
                class_1799 duckSack = new class_1799((class_1935)ModItems.DUCK_SACK.get());
                duckSack.method_57379(class_9334.field_49609, (Object)class_9279.method_57456((class_2487)duckData));
                if (stackInHand.method_7960()) {
                    player.method_6122(hand, duckSack);
                } else if (!player.method_7270(duckSack)) {
                    player.method_7328(duckSack, false);
                }
                this.method_37908().method_8396(null, this.method_24515(), ModSoundEvents.DUCK_SACK_USE.get(), class_3419.field_15254, 1.0f, 1.0f);
            } else {
                LOGGER.error("Could not save duck data to duck sack!");
            }
            this.method_31472();
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    protected boolean isTamableItem(class_1799 stack) {
        return DuckEntity.getTamingIngredient().method_8093(stack);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        DuckEntity duckEntity = (DuckEntity)ModEntityTypes.getDuck().method_5883((class_1937)world, class_3730.field_16466);
        if (duckEntity != null && entity instanceof DuckEntity) {
            DuckEntity duck = (DuckEntity)entity;
            if (this.field_5974.method_43056()) {
                duckEntity.setVariant(this.getVariant());
            } else {
                duckEntity.setVariant(duck.getVariant());
            }
            if (this.method_6181()) {
                duckEntity.method_6174(this.method_6139());
                duckEntity.method_6173(true, true);
            }
        }
        return duckEntity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate);
        controller.setParticleKeyframeHandler((AnimationController.ParticleKeyframeHandler)this);
        controllerRegistrar.add(controller);
    }

    @Override
    protected class_3414 getLayEggSound() {
        return ModSoundEvents.DUCK_LAY_EGG.get();
    }

    @Override
    public class_1792 getEggItem() {
        return ModItems.DUCK_EGG.get();
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.method_5799();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.method_6172()) {
            controller.setAnimation(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 1: {
                controller.setAnimation(inWater ? SWIM_CLEAN_ANIM : CLEAN_ANIM);
                break;
            }
            case 2: {
                controller.setAnimation(DIVE_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(DANCE_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            case 5: {
                controller.setAnimation(EAT_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void method_5966() {
        if (this.method_6109()) {
            this.method_5783(ModSoundEvents.DUCKLING_AMBIENT.get(), 0.3f, this.method_6017());
            return;
        }
        this.method_5783(ModSoundEvents.DUCK_AMBIENT.get(), 0.1f, this.method_6017());
    }

    protected void method_6013(class_1282 source) {
        if (this.method_6109()) {
            this.method_5783(ModSoundEvents.DUCKLING_HURT.get(), 0.3f, this.method_6017() + 0.25f);
            return;
        }
        this.method_5783(ModSoundEvents.DUCK_HURT.get(), 0.1f, this.method_6017() + 0.5f);
    }

    @Nullable
    protected class_3414 method_6002() {
        if (this.method_6109()) {
            return ModSoundEvents.DUCKLING_DEATH.get();
        }
        return ModSoundEvents.DUCK_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(ModSoundEvents.DUCK_STEP.get(), 0.15f, 1.0f);
    }

    public void handle(ParticleKeyframeEvent particleKeyframeEvent) {
        class_1799 stack = this.method_6047();
        if (stack == class_1799.field_8037) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            class_243 vel = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vel = vel.method_1037(-this.method_36455() * ((float)Math.PI / 180));
            vel = vel.method_1024(-this.method_36454() * ((float)Math.PI / 180));
            class_243 rotationVec = class_243.method_1030((float)0.0f, (float)this.field_6283);
            class_243 pos = new class_243(this.method_23317() + rotationVec.field_1352 / 2.0, this.method_23320() - 0.2, this.method_23321() + rotationVec.field_1350 / 2.0);
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, stack), pos.field_1352, pos.field_1351, pos.field_1350, vel.field_1352, vel.field_1351 + 0.05, vel.field_1350);
        }
    }

    public boolean method_17326() {
        return super.method_17326() || this.isFromSack;
    }

    public boolean isFromSack() {
        return this.isFromSack;
    }

    public void setFromSack(boolean fromSack) {
        this.isFromSack = fromSack;
    }

    public class_1799 method_24523(class_3218 world, class_1799 equipment) {
        class_1304 equipmentSlot = class_1304.field_6173;
        class_1799 itemStack = this.method_6047();
        if (this.method_5939(equipment)) {
            class_1542 itemEntity;
            if (!itemStack.method_7960() && (itemEntity = this.method_5775(world, itemStack)) != null) {
                itemEntity.method_6982(40);
            }
            this.method_24834(equipmentSlot, equipment);
            return equipment;
        }
        return class_1799.field_8037;
    }

    protected void method_5949(class_3218 world, class_1542 item) {
        if (this.method_6181() && !this.method_6047().method_7960() && item.method_24921() != null && !item.method_24921().method_5667().equals(this.method_6139())) {
            return;
        }
        super.method_5949(world, item);
    }

    public boolean method_5939(class_1799 stack) {
        class_1799 mainHandStack = this.method_6047();
        if (mainHandStack.method_7960()) {
            return this.method_6481(stack) || this.isTamableItem(stack);
        }
        if (this.method_6181() && !mainHandStack.method_7960()) {
            return this.method_6481(stack);
        }
        return this.isTamableItem(mainHandStack) && this.method_6481(stack);
    }

    public boolean method_5936() {
        if (this.method_6109()) {
            return false;
        }
        return !this.method_6047().method_7960() || this.isHungry();
    }

    public void fishing() {
        MinecraftServer server = this.method_37908().method_8503();
        if (!this.method_37908().field_9236 && server != null) {
            class_3218 world = (class_3218)this.method_37908();
            class_8567 lootWorldContext = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)class_1802.field_8378.method_7854()).method_51874(class_181.field_1226, (Object)this).method_51871((float)this.method_45325(class_5134.field_23726)).method_51875(class_173.field_1176);
            class_52 lootTable = server.method_58576().method_58295(class_39.field_353);
            ObjectArrayList list = lootTable.method_51878(lootWorldContext);
            for (class_1799 stack : list) {
                if (!this.method_6181() && !this.isTamableItem(stack)) continue;
                this.method_6122(class_1268.field_5808, stack);
                this.method_24834(class_1304.field_6173, stack);
                break;
            }
        }
    }

    @Override
    public boolean tamedNotFollowOwner() {
        return UntitledConfig.duckTamedNotFollow();
    }

    private class VibrationCallback
    implements class_8514.class_5719 {
        private final class_5716 positionSource;

        private VibrationCallback() {
            this.positionSource = new class_5709((class_1297)DuckEntity.this, DuckEntity.this.method_5751());
        }

        public int method_49797() {
            return 10;
        }

        public class_5716 method_51300() {
            return this.positionSource;
        }

        public boolean method_32970(class_3218 world, class_2338 pos, class_6880<class_5712> event, class_5712.class_7397 emitter) {
            return !DuckEntity.this.method_5987();
        }

        public void method_32969(class_3218 world, class_2338 pos, class_6880<class_5712> event, @Nullable class_1297 sourceEntity, @Nullable class_1297 entity, float distance) {
        }
    }

    private class JukeboxEventListener
    implements class_5714 {
        private final class_5716 positionSource;
        private final int range;

        public JukeboxEventListener(class_5716 positionSource, int range) {
            this.positionSource = positionSource;
            this.range = range;
        }

        public class_5716 method_32946() {
            return this.positionSource;
        }

        public int method_32948() {
            return this.range;
        }

        public boolean method_32947(class_3218 world, class_6880<class_5712> event, class_5712.class_7397 emitter, class_243 emitterPos) {
            if (event == class_5712.field_39485) {
                DuckEntity.this.method_6006(class_2338.method_49638((class_2374)emitterPos), true);
                return true;
            }
            if (event == class_5712.field_39486) {
                DuckEntity.this.method_6006(class_2338.method_49638((class_2374)emitterPos), false);
                return true;
            }
            return false;
        }
    }

    static class CleanGoal
    extends class_1352 {
        private static final int ANIMATION_LENGTH = 32;
        private final DuckEntity duck;
        private int cleanTime;
        private int nextCleanTime;

        public CleanGoal(DuckEntity duck) {
            this.duck = duck;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
            this.nextCleanTime = duck.field_6012 + (200 + duck.method_59922().method_43048(10) * 20);
        }

        public boolean method_6264() {
            if (this.nextCleanTime > this.duck.field_6012 || this.duck.method_6131() >= 100 || this.duck.getAnimation() != 0) {
                return false;
            }
            return this.duck.method_59922().method_43048(40) == 0;
        }

        public void method_6269() {
            this.cleanTime = 32;
            this.duck.setAnimation((byte)1);
            this.nextCleanTime = this.duck.field_6012 + (200 + this.duck.method_59922().method_43048(10) * 20);
        }

        public void method_6270() {
            this.duck.setAnimation((byte)0);
        }

        public boolean method_6266() {
            return this.cleanTime >= 0;
        }

        public void method_6268() {
            --this.cleanTime;
        }
    }

    static class DiveGoal
    extends class_1352 {
        private static final int ANIMATION_LENGTH = 32;
        private final DuckEntity duck;
        private int diveTime;
        private int nextDiveTime;

        public DiveGoal(DuckEntity duck) {
            this.duck = duck;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
            this.nextDiveTime = duck.field_6012 + (160 + duck.method_59922().method_43048(10) * 20);
        }

        public boolean method_6264() {
            if (this.nextDiveTime > this.duck.field_6012 || this.duck.method_6131() >= 100 || !this.duck.method_5799() || this.duck.getAnimation() != 0) {
                return false;
            }
            return this.duck.method_59922().method_43048(40) == 0 && this.duck.method_6047().method_7960();
        }

        public void method_6269() {
            this.diveTime = 32;
            this.duck.setAnimation((byte)2);
            this.nextDiveTime = this.duck.field_6012 + (160 + this.duck.method_59922().method_43048(10) * 20);
        }

        public void method_6270() {
            this.duck.setAnimation((byte)0);
        }

        public boolean method_6266() {
            return this.diveTime >= 0;
        }

        public void method_6268() {
            --this.diveTime;
            if (this.diveTime == 22) {
                if (this.duck.method_59922().method_43058() < UntitledConfig.duckFishingChange()) {
                    this.duck.fishing();
                }
                this.duck.method_5783(class_3417.field_14737, 1.0f, 1.0f);
            }
        }
    }
}

