/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.client.model;

import net.minecraft.resources.ResourceLocation;
import net.untitledduckmod.client.model.ModelIdentifiers;
import net.untitledduckmod.common.entity.DuckEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.renderer.GeoRenderer;

public class DuckModel
extends GeoModel<DuckEntity> {
    public ResourceLocation getModelResource(DuckEntity animatable, @Nullable GeoRenderer<DuckEntity> renderer) {
        return ModelIdentifiers.DUCK_MODEL_LOCATION;
    }

    public ResourceLocation getTextureResource(DuckEntity animatable, @Nullable GeoRenderer<DuckEntity> renderer) {
        if (animatable.isBaby()) {
            return ModelIdentifiers.DUCKLING_TEXTURE;
        }
        return animatable.getVariant() == 0 ? ModelIdentifiers.NORMAL_TEXTURE : ModelIdentifiers.FEMALE_TEXTURE;
    }

    public ResourceLocation getAnimationResource(DuckEntity animatable) {
        return ModelIdentifiers.DUCK_ANIMATION_FILE_LOCATION;
    }

    public void setCustomAnimations(DuckEntity animatable, long instanceId, AnimationState<DuckEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (animatable.lookingAround() && head != null) {
            EntityModelData extraData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

