/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.untitledduckmod.client.model.DuckModel;
import net.untitledduckmod.common.entity.DuckEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class DuckRenderer
extends GeoEntityRenderer<DuckEntity> {
    private final ItemInHandRenderer heldItemRenderer;

    public DuckRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new DuckModel());
        this.shadowRadius = 0.3f;
        this.heldItemRenderer = context.getEntityRenderDispatcher().getItemInHandRenderer();
    }

    public void preRender(PoseStack poseStack, DuckEntity animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (animatable.isBaby()) {
            this.withScale(0.7f);
        } else {
            this.withScale(1.0f);
        }
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    public void renderRecursively(PoseStack poseStack, DuckEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        ItemStack mainHand = animatable.getMainHandItem();
        if (bone.getName().equals("beak") && !mainHand.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.5, -0.4);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.scale(0.7f, 0.7f, 0.7f);
            this.heldItemRenderer.renderItem((LivingEntity)animatable, mainHand, ItemDisplayContext.GROUND, false, poseStack, bufferSource, packedLight);
            poseStack.popPose();
        }
    }
}

