/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.init;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.untitledduckmod.DuckMod;
import net.untitledduckmod.common.entity.DuckEntity;
import net.untitledduckmod.common.entity.GooseEntity;
import net.untitledduckmod.common.entity.WaterfowlEggEntity;
import net.untitledduckmod.common.init.neoforge.ModEntityTypesImpl;
import net.untitledduckmod.common.platform.RegistryHelper;

public class ModEntityTypes {
    public static final Supplier<EntityType<DuckEntity>> DUCK;
    public static final Supplier<EntityType<WaterfowlEggEntity>> DUCK_EGG;
    public static final Supplier<EntityType<GooseEntity>> GOOSE;
    public static final Supplier<EntityType<WaterfowlEggEntity>> GOOSE_EGG;
    public static final ResourceKey<EntityType<?>> duckKey;
    public static final ResourceKey<EntityType<?>> duckEggKey;
    public static final ResourceKey<EntityType<?>> gooseKey;
    public static final ResourceKey<EntityType<?>> gooseEggKey;

    public static void init() {
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerAttributes(Object optionalEvent) {
        ModEntityTypesImpl.registerAttributes(optionalEvent);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setupSpawning(Object optionalEvent) {
        ModEntityTypesImpl.setupSpawning(optionalEvent);
    }

    public static EntityType<DuckEntity> getDuck() {
        return DUCK.get();
    }

    public static EntityType<WaterfowlEggEntity> getDuckEgg() {
        return DUCK_EGG.get();
    }

    public static EntityType<GooseEntity> getGoose() {
        return GOOSE.get();
    }

    public static EntityType<WaterfowlEggEntity> getGooseEgg() {
        return GOOSE_EGG.get();
    }

    static {
        duckKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)DuckMod.id("duck"));
        duckEggKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)DuckMod.id("duck_egg"));
        gooseKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)DuckMod.id("goose"));
        gooseEggKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)DuckMod.id("goose_egg"));
        DUCK = RegistryHelper.registerEntity("duck", () -> EntityType.Builder.of(DuckEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.6f).clientTrackingRange(10).build(duckKey));
        DUCK_EGG = RegistryHelper.registerEntity("duck_egg", () -> EntityType.Builder.of(WaterfowlEggEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build(duckEggKey));
        GOOSE = RegistryHelper.registerEntity("goose", () -> EntityType.Builder.of(GooseEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 1.2f).clientTrackingRange(10).build(gooseKey));
        GOOSE_EGG = RegistryHelper.registerEntity("goose_egg", () -> EntityType.Builder.of(WaterfowlEggEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build(gooseEggKey));
    }
}

