/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.init;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.neoforge.ModItemsImpl;
import net.untitledduckmod.common.item.DuckSackItem;
import net.untitledduckmod.common.item.WaterfowlEggItem;
import net.untitledduckmod.common.platform.RegistryHelper;

public class ModItems {
    public static final Supplier<SpawnEggItem> DUCK_SPAWN_EGG;
    public static final Supplier<Item> DUCK_EGG;
    public static final Supplier<Item> RAW_DUCK;
    public static final Supplier<Item> COOKED_DUCK;
    public static final Supplier<Item> DUCK_FEATHER;
    public static final Supplier<Item> DUCK_SACK;
    public static final Supplier<Item> EMPTY_DUCK_SACK;
    public static final Supplier<SpawnEggItem> GOOSE_SPAWN_EGG;
    public static final Supplier<Item> GOOSE_EGG;
    public static final Supplier<Item> RAW_GOOSE;
    public static final Supplier<Item> COOKED_GOOSE;
    public static final Supplier<Item> GOOSE_FOOT;

    public static void init() {
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setupItemGroups(Object optionalEvent) {
        ModItemsImpl.setupItemGroups(optionalEvent);
    }

    static {
        RAW_DUCK = RegistryHelper.registerItem("raw_duck", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.4f).build()));
        COOKED_DUCK = RegistryHelper.registerItem("cooked_duck", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(6).saturationModifier(0.8f).build()));
        RAW_GOOSE = RegistryHelper.registerItem("raw_goose", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(3).saturationModifier(0.6f).build()));
        COOKED_GOOSE = RegistryHelper.registerItem("cooked_goose", Item::new, new Item.Properties().food(new FoodProperties.Builder().nutrition(8).saturationModifier(1.0f).build()));
        DUCK_EGG = RegistryHelper.registerItem("duck_egg", settings -> new WaterfowlEggItem((Item.Properties)settings, ModEntityTypes::getDuckEgg, ModEntityTypes::getDuck), new Item.Properties().stacksTo(16));
        DUCK_FEATHER = RegistryHelper.registerItem("duck_feather", Item::new, new Item.Properties());
        DUCK_SACK = RegistryHelper.registerItem("duck_sack", DuckSackItem::new, new Item.Properties());
        EMPTY_DUCK_SACK = RegistryHelper.registerItem("empty_duck_sack", Item::new, new Item.Properties());
        GOOSE_EGG = RegistryHelper.registerItem("goose_egg", settings -> new WaterfowlEggItem((Item.Properties)settings, ModEntityTypes::getGooseEgg, ModEntityTypes::getGoose), new Item.Properties().stacksTo(16));
        GOOSE_FOOT = RegistryHelper.registerItem("goose_foot", Item::new, new Item.Properties());
        DUCK_SPAWN_EGG = RegistryHelper.registerSpawnEggItem("duck_spawn_egg", ModEntityTypes.DUCK);
        GOOSE_SPAWN_EGG = RegistryHelper.registerSpawnEggItem("goose_spawn_egg", ModEntityTypes.GOOSE);
    }
}

