/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.platform.neoforge;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.untitledduckmod.DuckMod;
import net.untitledduckmod.common.entity.neoforge.DuckEntityForge;
import net.untitledduckmod.common.entity.neoforge.GooseEntityForge;
import net.untitledduckmod.common.init.ModEntityTypes;

public class RegistryHelperImpl {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"untitledduckmod");
    public static final DeferredRegister.Entities ENTITY_TYPES = DeferredRegister.createEntities((String)"untitledduckmod");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"untitledduckmod");
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((Registry)BuiltInRegistries.POTION, (String)"untitledduckmod");
    public static final DeferredRegister<MobEffect> STATUS_EFFECTS = DeferredRegister.create((Registry)BuiltInRegistries.MOB_EFFECT, (String)"untitledduckmod");
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"untitledduckmod");

    public static <T extends Item> Supplier<T> registerItem(String name, Function<Item.Properties, T> factory, Item.Properties settings) {
        return ITEMS.registerItem(name, factory);
    }

    public static Supplier<SpawnEggItem> registerSpawnEggItem(String name, Supplier<? extends EntityType<? extends Mob>> type) {
        return RegistryHelperImpl.registerItem(name, settings -> new SpawnEggItem((EntityType)type.get(), settings), new Item.Properties());
    }

    public static <T extends EntityType<?>> Supplier<T> registerEntity(String name, Supplier<T> entityType) {
        if (name.equals("duck")) {
            entityType = () -> EntityType.Builder.of(DuckEntityForge::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.6f).clientTrackingRange(10).build(ModEntityTypes.duckKey);
        } else if (name.equals("goose")) {
            entityType = () -> EntityType.Builder.of(GooseEntityForge::new, (MobCategory)MobCategory.CREATURE).sized(0.7f, 1.2f).clientTrackingRange(10).build(ModEntityTypes.gooseKey);
        }
        return ENTITY_TYPES.register(name, entityType);
    }

    public static Supplier<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)DuckMod.id(name)));
    }

    public static Holder<Potion> registerPotion(String name, Supplier<Potion> potion) {
        return POTIONS.register(name, potion);
    }

    public static Holder<MobEffect> registerStatusEffect(String name, Supplier<MobEffect> statusEffect) {
        return STATUS_EFFECTS.register(name, statusEffect);
    }

    public static <T extends MapCodec<? extends BiomeModifier>> void registerBiomeModifier(String name, Supplier<T> biomeModifier) {
        BIOME_MODIFIERS.register(name, biomeModifier);
    }
}

