/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.client.model;

import java.util.Objects;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.untitledduckmod.client.model.ModelIdentifiers;
import net.untitledduckmod.client.model.WaterfowlModel;
import net.untitledduckmod.common.entity.GooseEntity;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public class GooseModel
extends WaterfowlModel<GooseEntity> {
    public GooseModel() {
        super(ResourceLocation.fromNamespaceAndPath((String)"untitledduckmod", (String)"goose"));
    }

    public ResourceLocation getTextureResource(GeoRenderState renderState) {
        if (renderState instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingEntityRenderState = (LivingEntityRenderState)renderState;
            if (livingEntityRenderState.isBaby) {
                return ModelIdentifiers.GOSLING_TEXTURE;
            }
            if (livingEntityRenderState.customName != null) {
                String name;
                switch (name = Objects.requireNonNull(livingEntityRenderState.customName).getString().toLowerCase()) {
                    case "ping": {
                        return ModelIdentifiers.PING_GOOSE_TEXTURE;
                    }
                    case "sus": {
                        return ModelIdentifiers.SUS_GOOSE_TEXTURE;
                    }
                    case "untitled": {
                        return ModelIdentifiers.UNTITLED_GOOSE_TEXTURE;
                    }
                }
            }
        }
        byte variant = renderState.hasGeckolibData(WaterfowlEntity.VARIANT_TICKET) ? (Byte)renderState.getGeckolibData(WaterfowlEntity.VARIANT_TICKET) : (byte)0;
        return variant == 0 ? ModelIdentifiers.GOOSE_TEXTURE : ModelIdentifiers.CANADIAN_GOOSE_TEXTURE;
    }
}

