/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.untitledduckmod.client.model.WaterfowlModel;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import net.untitledduckmod.common.init.ModEntityTypes;
import org.joml.Quaternionfc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.util.ClientUtil;

public class WaterfowlRenderer<T extends WaterfowlEntity, R extends LivingEntityRenderState>
extends GeoEntityRenderer<T, R> {
    private static final float ADULT_SHADOW_RADIUS = 0.3f;

    public WaterfowlRenderer(WaterfowlModel<T> model, EntityRendererProvider.Context context) {
        super(context, model);
        this.shadowRadius = 0.3f;
    }

    protected float getShadowRadius(R state) {
        return super.getShadowRadius(state) * ((LivingEntityRenderState)state).ageScale;
    }

    public void addRenderData(T animatable, Void relatedObject, R renderState) {
        EnumMap equipment = (EnumMap)((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, new EnumMap(EquipmentSlot.class));
        equipment.put(EquipmentSlot.MAINHAND, animatable.getMainHandItem());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, (Object)equipment);
        ((GeoRenderState)renderState).addGeckolibData(WaterfowlEntity.VARIANT_TICKET, (Object)((WaterfowlEntity)((Object)animatable)).getVariant());
    }

    public void scaleModelForRender(R renderState, float widthScale, float heightScale, PoseStack poseStack, BakedGeoModel model, boolean isReRender) {
        float modelScale = ((LivingEntityRenderState)renderState).ageScale;
        this.withScale(modelScale);
        super.scaleModelForRender(renderState, widthScale, heightScale, poseStack, model, isReRender);
    }

    public void renderRecursively(R renderState, PoseStack poseStack, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        EnumMap equipment = (EnumMap)((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, new EnumMap(EquipmentSlot.class));
        ItemStack mainHand = equipment.getOrDefault(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        if (bone.getName().equals("beak") && !mainHand.isEmpty()) {
            poseStack.pushPose();
            if (((LivingEntityRenderState)renderState).entityType == ModEntityTypes.getDuck()) {
                poseStack.translate(0.0, 0.5, -0.4);
            } else if (((LivingEntityRenderState)renderState).entityType == ModEntityTypes.getGoose()) {
                poseStack.translate(0.0, 1.15, -0.45);
            }
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            poseStack.scale(0.7f, 0.7f, 0.7f);
            Minecraft.getInstance().getItemRenderer().renderStatic(mainHand, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, ClientUtil.getLevel(), ((Long)((GeoRenderState)renderState).getGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID)).intValue());
            poseStack.popPose();
        }
        super.renderRecursively(renderState, poseStack, bone, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
    }
}

