/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.helper;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.untitledduckmod.common.helper.neoforge.NbtHelperImpl;

public class NbtHelper {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean contains(ItemStack stack, DataComponentType<?> type) {
        void var1_1;
        return NbtHelperImpl.contains(stack, var1_1);
    }

    public static boolean containsUuid(CompoundTag tag, String key) {
        Tag nbtElement = tag.get(key);
        return nbtElement != null && nbtElement.getType() == IntArrayTag.TYPE && ((IntArrayTag)nbtElement).getAsIntArray().length == 4;
    }

    public static CustomData get(ItemStack stack, DataComponentType<CustomData> type) {
        CustomData nbt = (CustomData)stack.getComponents().get(type);
        if (nbt == null) {
            throw new NullPointerException("NbtComponent is null");
        }
        return nbt;
    }

    private static UUID toUuid(Tag element) {
        if (element == null) {
            throw new NullPointerException("NbtElement is null");
        }
        if (element.getType() != IntArrayTag.TYPE) {
            String var10002 = IntArrayTag.TYPE.getName();
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + var10002 + ", but found " + element.getType().getName() + ".");
        }
        int[] is = ((IntArrayTag)element).getAsIntArray();
        if (is.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + is.length + ".");
        }
        return UUIDUtil.uuidFromIntArray((int[])is);
    }

    public static UUID getUuid(CompoundTag tag, String key) {
        return NbtHelper.toUuid(tag.get(key));
    }
}

