/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.client.model;

import java.util.Objects;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.untitledduckmod.client.model.ModelIdentifiers;
import net.untitledduckmod.client.model.WaterfowlModel;
import net.untitledduckmod.common.entity.DuckEntity;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public class DuckModel
extends WaterfowlModel<DuckEntity> {
    public DuckModel() {
        super(ResourceLocation.fromNamespaceAndPath((String)"untitledduckmod", (String)"duck"));
    }

    public ResourceLocation getTextureResource(GeoRenderState renderState) {
        if (renderState instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingEntityRenderState = (LivingEntityRenderState)renderState;
            if (livingEntityRenderState.isBaby) {
                return ModelIdentifiers.DUCKLING_TEXTURE;
            }
            if (livingEntityRenderState.customName != null) {
                String name;
                switch (name = Objects.requireNonNull(livingEntityRenderState.customName).getString().toLowerCase()) {
                    case "pekin": {
                        return ModelIdentifiers.PEKIN_TEXTURE;
                    }
                }
            }
        }
        int variant = renderState.hasGeckolibData(WaterfowlEntity.VARIANT_TICKET) ? (int)((Byte)renderState.getGeckolibData(WaterfowlEntity.VARIANT_TICKET)).byteValue() : 0;
        return switch (variant) {
            case 1 -> ModelIdentifiers.FEMALE_TEXTURE;
            case 2 -> ModelIdentifiers.CAMPBELL_TEXTURE;
            default -> ModelIdentifiers.NORMAL_TEXTURE;
        };
    }
}

