/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModItems;

public class WaterfowlEggEntity
extends ThrowableItemProjectile {
    private final EntityType<? extends WaterfowlEntity> mobEntityType;
    private static final EntityDimensions EMPTY_DIMENSIONS = EntityDimensions.fixed((float)0.0f, (float)0.0f);

    public WaterfowlEggEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
        this.mobEntityType = ModEntityTypes.getDuck();
    }

    public WaterfowlEggEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world, ItemStack stack, double x, double y, double z) {
        super(entityType, x, y, z, world, stack);
        this.mobEntityType = ModEntityTypes.getDuck();
    }

    public WaterfowlEggEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world, LivingEntity owner, ItemStack stack, EntityType<? extends WaterfowlEntity> mobEntityType) {
        super(entityType, owner, world, stack);
        this.mobEntityType = mobEntityType;
    }

    public WaterfowlEggEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world, ItemStack stack, double x, double y, double z, EntityType<? extends WaterfowlEntity> mobEntityType) {
        super(entityType, x, y, z, world, stack);
        this.mobEntityType = mobEntityType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte status) {
        if (status == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            entityHitResult.getEntity().hurtServer(serverWorld, this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        }
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        Level world = this.level();
        if (!world.isClientSide) {
            if (this.random.nextInt(8) == 0) {
                int i = 1;
                if (this.random.nextInt(32) == 0) {
                    i = 4;
                }
                for (int j = 0; j < i; ++j) {
                    WaterfowlEntity waterfowl = (WaterfowlEntity)this.mobEntityType.create(this.level(), EntitySpawnReason.TRIGGERED);
                    if (waterfowl == null) continue;
                    waterfowl.setAge(-24000);
                    waterfowl.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    waterfowl.setVariant((byte)this.level().getRandom().nextInt(2));
                    if (!waterfowl.fudgePositionAfterSizeChange(EMPTY_DIMENSIONS)) break;
                    world.addFreshEntity((Entity)waterfowl);
                }
            }
            world.broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        if (this.mobEntityType == ModEntityTypes.getDuck()) {
            return ModItems.DUCK_EGG.get();
        }
        return ModItems.GOOSE_EGG.get();
    }
}

