/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.untitledduckmod.common.config.UntitledConfig;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public abstract class WaterfowlEntity
extends TamableAnimal
implements GeoAnimatable {
    protected ProblemReporter errorReporter;
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final float BABY_MIN_SCALE = 0.25f;
    public static final float BABY_MAX_SCALE = 0.7f;
    public static final String EGG_LAY_TIME_TAG = "EggLayTime";
    public static final String VARIANT_TAG = "Variant";
    public static final String BABY_SCALE_TAG = "BabyScale";
    public static final float SWIM_SPEED_MULTIPLIER = 3.0f;
    public static final DataTicket<Boolean> LOOKING_AROUND_TICKET = DataTicket.create((String)"look_around", Boolean.class);
    public static final DataTicket<Byte> VARIANT_TICKET = DataTicket.create((String)"waterfowl_variant", Byte.class);
    public static final DataTicket<Float> BABY_SCALE_TICKET = DataTicket.create((String)"waterfowl_baby_scale", Float.class);
    protected static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.defineId(WaterfowlEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Float> BABY_SCALE = SynchedEntityData.defineId(WaterfowlEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.defineId(WaterfowlEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final byte ANIMATION_IDLE = 0;
    public static final byte ANIMATION_CLEAN = 1;
    public static final byte ANIMATION_DANCE = 3;
    public static final byte ANIMATION_PANIC = 4;
    public static final byte ANIMATION_EAT = 5;
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenPlay("walk");
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation SWIM_ANIM = RawAnimation.begin().thenPlay("swim");
    protected static final RawAnimation SWIM_IDLE_ANIM = RawAnimation.begin().thenPlay("idle_swim");
    protected static final RawAnimation PANIC_ANIM = RawAnimation.begin().thenPlay("panic");
    protected static final RawAnimation FLY_ANIM = RawAnimation.begin().thenPlay("fly");
    protected static final RawAnimation CLEAN_ANIM = RawAnimation.begin().thenPlay("clean");
    protected static final RawAnimation EAT_ANIM = RawAnimation.begin().thenPlay("eat");
    protected static final RawAnimation SIT_ANIM = RawAnimation.begin().thenPlay("sit");
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    protected int maxVariant = 2;
    protected int eggLayTime = this.getRandomLayTime();
    protected boolean isFlapping;
    protected boolean panicked = false;

    protected WaterfowlEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.errorReporter = new ProblemReporter.ScopedCollector(() -> entityType.getDescription().toString(), LOGGER);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData entityData) {
        float babyScale = this.getRandomBabyScale();
        byte variant = this.getRandomVariant();
        if (entityData instanceof GeoRenderState) {
            GeoRenderState geoRenderState = (GeoRenderState)entityData;
            geoRenderState.addGeckolibData(BABY_SCALE_TICKET, (Object)Float.valueOf(babyScale));
            geoRenderState.addGeckolibData(VARIANT_TICKET, (Object)variant);
            geoRenderState.addGeckolibData(LOOKING_AROUND_TICKET, (Object)this.lookingAround());
        }
        this.setVariant(variant);
        this.setBabyScale(babyScale);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(ANIMATION, (Object)0);
        builder.define(BABY_SCALE, (Object)Float.valueOf(this.getRandomBabyScale()));
    }

    public void addAdditionalSaveData(ValueOutput view) {
        super.addAdditionalSaveData(view);
        view.putByte(VARIANT_TAG, this.getVariant());
        view.putInt(EGG_LAY_TIME_TAG, this.eggLayTime);
        view.putFloat(BABY_SCALE_TAG, this.getBabyScale());
    }

    public void readAdditionalSaveData(ValueInput view) {
        super.readAdditionalSaveData(view);
        this.setVariant(view.getByteOr(VARIANT_TAG, this.getRandomVariant()));
        this.setBabyScale(view.getFloatOr(BABY_SCALE_TAG, this.getRandomBabyScale()));
        this.eggLayTime = view.getIntOr(EGG_LAY_TIME_TAG, this.getRandomLayTime());
    }

    public void setTame(boolean tamed, boolean updateAttributes) {
        super.setTame(tamed, updateAttributes);
        if (tamed) {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(20.0);
            this.setHealth(20.0f);
        } else {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(7.0);
        }
    }

    public boolean causeFallDamage(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public byte getVariant() {
        return (Byte)this.entityData.get(VARIANT);
    }

    public void setVariant(byte variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public float getRandomBabyScale() {
        return this.random.nextFloat() * 0.45f + 0.25f;
    }

    public float getBabyScale() {
        return ((Float)this.entityData.get(BABY_SCALE)).floatValue();
    }

    public void setBabyScale(float scale) {
        this.entityData.set(BABY_SCALE, (Object)Float.valueOf(scale));
    }

    public byte getRandomVariant() {
        return (byte)this.random.nextInt(this.maxVariant);
    }

    public int getRandomLayTime() {
        return this.random.nextInt(6000) + 6000;
    }

    public byte getAnimation() {
        return (Byte)this.entityData.get(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public boolean isHungry() {
        return this.getHealth() <= this.getMaxHealth() - 0.5f;
    }

    public void tryEating() {
        assert (!this.level().isClientSide());
        ItemStack stack = this.getMainHandItem();
        stack.shrink(1);
        this.playSound((SoundEvent)SoundEvents.GENERIC_EAT.value(), 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        if (stack.isEmpty()) {
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        if (this.isHungry()) {
            FoodProperties food = (FoodProperties)stack.get(DataComponents.FOOD);
            this.heal(food != null ? (float)food.nutrition() : UntitledConfig.foodHealingValue());
        }
    }

    public boolean lookingAround() {
        return this.getAnimation() != 1 || this.getAnimation() != 5;
    }

    protected abstract SoundEvent getLayEggSound();

    public abstract Item getEggItem();

    public void aiStep() {
        super.aiStep();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (this.isAlive() && !this.isBaby() && --this.eggLayTime <= 0) {
                this.playSound(this.getLayEggSound(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.spawnAtLocation(world, (ItemLike)this.getEggItem());
                this.eggLayTime = this.getRandomLayTime();
            }
            Vec3 velocity = this.getDeltaMovement();
            if (!this.onGround() && velocity.y < 0.0) {
                this.setDeltaMovement(velocity.multiply(1.0, 0.6, 1.0));
            }
            this.handlePanicAnimation();
        }
        this.isFlapping = this.level().isClientSide && !this.isInWater() && !this.onGround();
    }

    protected abstract void handlePanicAnimation();

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(!this.level().isClientSide || this.isBaby() && this.isFood(stack))) {
            if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            return !this.isTamableItem(stack) || !(this.getHealth() < this.getMaxHealth()) && this.isTame() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            if (this.isFood(stack) && this.getHealth() < this.getMaxHealth()) {
                FoodProperties food = (FoodProperties)stack.get(DataComponents.FOOD);
                this.usePlayerItem(player, hand, stack);
                this.heal(food != null ? (float)food.nutrition() : UntitledConfig.foodHealingValue());
                return InteractionResult.CONSUME;
            }
            InteractionResult actionResult = super.mobInteract(player, hand);
            if (!actionResult.consumesAction() || this.isBaby()) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
            }
            return actionResult;
        }
        if (this.tryTaming(player, stack)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (this.random.nextInt(3) == 0) {
                this.tame(player);
                this.navigation.stop();
                this.setTarget(null);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    protected boolean tryTaming(Player player, ItemStack stack) {
        return this.isTamable(player, stack);
    }

    protected abstract boolean isTamableItem(ItemStack var1);

    protected boolean isTamable(Player player, ItemStack stack) {
        return this.isTamableItem(stack) && !this.isTame();
    }

    protected void jumpInLiquid(TagKey<Fluid> fluid) {
        if (this.getNavigation().canFloat()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.04f, 0.0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        this.setOrderedToSit(false);
        return super.hurtServer(world, source, amount);
    }

    public double getTick(Object o) {
        return this.tickCount;
    }

    public int getEggLayTime() {
        return this.eggLayTime;
    }

    public boolean tamedFollowOwner() {
        return true;
    }
}

