/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.init.neoforge;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.untitledduckmod.common.config.UntitledConfig;
import net.untitledduckmod.common.entity.CustomSpawnGroup;
import net.untitledduckmod.common.entity.DuckEntity;
import net.untitledduckmod.common.entity.GooseEntity;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModTags;

public class ModEntityTypesImpl {
    public static void registerAttributes(Object optionalEvent) {
        if (optionalEvent instanceof EntityAttributeCreationEvent) {
            EntityAttributeCreationEvent event = (EntityAttributeCreationEvent)optionalEvent;
            event.put(ModEntityTypes.getDuck(), DuckEntity.getDefaultAttributes().add(NeoForgeMod.SWIM_SPEED, 3.0).build());
            event.put(ModEntityTypes.getGoose(), GooseEntity.getDefaultAttributes().add(NeoForgeMod.SWIM_SPEED, 3.0).build());
        }
    }

    public static void setupSpawning(Object optionalEvent) {
        if (optionalEvent instanceof RegisterSpawnPlacementsEvent) {
            RegisterSpawnPlacementsEvent event = (RegisterSpawnPlacementsEvent)optionalEvent;
            event.register(ModEntityTypes.getDuck(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DuckEntity::checkDuckSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
            event.register(ModEntityTypes.getGoose(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GooseEntity::checkGooseSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        }
    }

    public static void addBiomeSpawns(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (biome.is(ModTags.BiomeTags.DUCK_BIOMES)) {
            builder.getMobSpawnSettings().getSpawner(CustomSpawnGroup.WATERFOWL.spawnGroup).add((Object)new MobSpawnSettings.SpawnerData(ModEntityTypes.getDuck(), UntitledConfig.duckMinGroupSize(), UntitledConfig.duckMaxGroupSize()), UntitledConfig.duckWeight());
        }
        if (biome.is(ModTags.BiomeTags.GOOSE_BIOMES)) {
            builder.getMobSpawnSettings().getSpawner(CustomSpawnGroup.WATERFOWL.spawnGroup).add((Object)new MobSpawnSettings.SpawnerData(ModEntityTypes.getGoose(), UntitledConfig.gooseMinGroupSize(), UntitledConfig.gooseMaxGroupSize()), UntitledConfig.gooseWeight());
        }
    }
}

