/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.item;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.untitledduckmod.common.entity.DuckEntity;
import net.untitledduckmod.common.helper.NbtHelper;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModItems;
import net.untitledduckmod.common.init.ModSoundEvents;

public class DuckSackItem
extends Item {
    public DuckSackItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide) {
            BlockPos pos = context.getClickedPos();
            BlockState blockState = world.getBlockState(pos);
            Player user = context.getPlayer();
            Direction blockSide = context.getClickedFace();
            InteractionHand hand = context.getHand();
            ItemStack stack = context.getItemInHand();
            if (user != null) {
                user.swing(hand);
                BlockPos placePos = blockState.getCollisionShape((BlockGetter)world, pos).isEmpty() ? pos : pos.relative(blockSide);
                if (this.placeCreature((ServerLevel)world, placePos, (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY))) {
                    world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_PLACE, pos);
                    ItemStack emptySack = new ItemStack((ItemLike)ModItems.EMPTY_DUCK_SACK.get());
                    user.awardStat(Stats.ITEM_USED.get((Object)this));
                    stack.consume(1, (LivingEntity)user);
                    if (stack.isEmpty()) {
                        user.setItemInHand(hand, emptySack);
                    } else if (!user.addItem(emptySack)) {
                        user.drop(emptySack, false);
                    }
                    world.playSound((Entity)user, pos, ModSoundEvents.DUCK_SACK_USE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        BlockHitResult blockHitResult = DuckSackItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = blockHitResult.getBlockPos();
        if (!(world.getBlockState(pos).getBlock() instanceof LiquidBlock)) {
            return InteractionResult.PASS;
        }
        if (world.mayInteract((Entity)user, pos) && user.mayUseItemAt(pos, blockHitResult.getDirection(), stack)) {
            if (this.placeCreature((ServerLevel)world, pos, (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY))) {
                user.awardStat(Stats.ITEM_USED.get((Object)this));
                world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_PLACE, pos);
                ItemStack emptySack = new ItemStack((ItemLike)ModItems.EMPTY_DUCK_SACK.get());
                stack.consume(1, (LivingEntity)user);
                if (stack.isEmpty()) {
                    user.setItemInHand(hand, emptySack);
                } else if (!user.addItem(emptySack)) {
                    user.drop(emptySack, false);
                }
                world.playSound((Entity)user, pos, ModSoundEvents.DUCK_SACK_USE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    private boolean placeCreature(ServerLevel world, BlockPos pos, CustomData itemData) {
        Entity newDuck;
        ProblemReporter.ScopedCollector errorReporter;
        ValueInput nbtReadView;
        Optional optional;
        UUID uuid;
        CompoundTag entityData = itemData.copyTag();
        if (NbtHelper.containsUuid(entityData, "UUID") && world.getEntity(uuid = NbtHelper.getUuid(entityData, "UUID")) != null) {
            entityData.remove("UUID");
        }
        String entityType = EntityType.getKey(ModEntityTypes.getDuck()).toString();
        if (!entityData.contains("id")) {
            entityData.putString("id", entityType);
        }
        if ((optional = EntityType.create((ValueInput)(nbtReadView = TagValueInput.create((ProblemReporter)(errorReporter = new ProblemReporter.ScopedCollector(() -> entityType, DuckEntity.LOGGER)), (HolderLookup.Provider)world.registryAccess(), (CompoundTag)entityData)), (Level)world, (EntitySpawnReason)EntitySpawnReason.BUCKET)).isPresent() && (newDuck = (Entity)optional.get()) instanceof DuckEntity) {
            DuckEntity duck = (DuckEntity)newDuck;
            duck.load(nbtReadView);
            duck.setFromSack(true);
            duck.snapTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5, Mth.wrapDegrees((float)(world.random.nextFloat() * 360.0f)), 0.0f);
            world.addFreshEntity((Entity)duck);
            return true;
        }
        return false;
    }

    public Component getName(ItemStack stack) {
        CompoundTag duckData;
        CustomData itemData;
        if (NbtHelper.contains(stack, DataComponents.ENTITY_DATA) && (itemData = NbtHelper.get(stack, (DataComponentType<CustomData>)DataComponents.ENTITY_DATA)) != null && (duckData = itemData.copyTag()).contains("CustomName")) {
            Component duckName = Component.nullToEmpty((String)duckData.getString("CustomName").orElse("duck"));
            return Component.translatable((String)"item.untitledduckmod.duck_sack.named", (Object[])new Object[]{duckName});
        }
        return super.getName(stack);
    }
}

