/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1399;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1543;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.untitledduckmod.common.config.UntitledConfig;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import net.untitledduckmod.common.entity.ai.goal.common.EatGoal;
import net.untitledduckmod.common.entity.ai.goal.common.SwimGoal;
import net.untitledduckmod.common.entity.ai.goal.common.WFollowParentGoal;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModItems;
import net.untitledduckmod.common.init.ModSoundEvents;
import net.untitledduckmod.common.init.ModTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GooseEntity
extends WaterfowlEntity
implements class_5354,
AnimationController.ParticleKeyframeHandler<GooseEntity> {
    private static final class_2940<Integer> ANGER_TIME = class_2945.method_12791(GooseEntity.class, (class_2941)class_2943.field_13327);
    private static final class_6019 ANGER_TIME_RANGE = class_6019.method_35017((int)20, (int)39);
    private UUID targetUuid;
    public static final byte ANIMATION_BITE = 2;
    public static final int ANIMATION_BITE_LEN = 22;
    public static final byte ANIMATION_INTIMIDATE = 6;
    private static final RawAnimation INTIMIDATE_ANIM = RawAnimation.begin().thenPlay("intimidate");
    private static final RawAnimation HONK_ANIM = RawAnimation.begin().thenPlay("honk");
    private static final RawAnimation BITE_ANIM = RawAnimation.begin().thenPlay("bite");
    private static final RawAnimation CHARGE_ANIM = RawAnimation.begin().thenPlay("charge");
    public static final class_1856 FOOD = class_1856.method_8106(ModTags.ItemTags.GOOSE_FOOD);
    private static final class_1856 BREEDING_INGREDIENT = class_1856.method_8106(ModTags.ItemTags.GOOSE_BREEDING_FOOD);
    private static final class_1856 TAMING_INGREDIENT = class_1856.method_8106(ModTags.ItemTags.GOOSE_TAMING_FOOD);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean wasSongPlaying = false;
    private int animationTimer = 0;

    public GooseEntity(class_1299<? extends WaterfowlEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5952(true);
    }

    public static boolean checkGooseSpawnRules(class_1299<GooseEntity> goose, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        boolean isValidSurface;
        class_2680 downState = world.method_8320(pos.method_10074());
        boolean bl = isValidSurface = downState.method_26164(ModTags.BlockTags.GEESE_SPAWNABLE_ON) || downState.method_26227().method_15767(class_3486.field_15517) || downState.method_27852(class_2246.field_10295) || downState.method_27852(class_2246.field_10110);
        boolean hasEnoughSpace = downState.method_27852(class_2246.field_10295) || downState.method_27852(class_2246.field_10110) ? world.method_8320(pos).method_26215() && world.method_8320(pos.method_10084()).method_26215() : world.method_8320(pos).method_26215();
        return isValidSurface && hasEnoughSpace;
    }

    public static class_5132.class_5133 getDefaultAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 7.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23721, 2.0);
    }

    @Override
    public void method_6173(boolean tamed, boolean updateAttributes) {
        super.method_6173(tamed, updateAttributes);
        Objects.requireNonNull(this.method_5996(class_5134.field_23721)).method_6192(2.0);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ANGER_TIME, (Object)0);
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.method_29517(tag);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.method_29512(this.method_37908(), tag);
    }

    public void method_6006(class_2338 songPosition, boolean playing) {
        if (playing && !this.wasSongPlaying) {
            this.setAnimation((byte)3);
            this.wasSongPlaying = true;
        } else if (!playing && this.wasSongPlaying) {
            this.setAnimation((byte)0);
            this.wasSongPlaying = false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 100) {
            class_2400 particleEffect = class_2398.field_11211;
            for (int i = 0; i < 7; ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        }
        super.method_5711(status);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SwimGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GooseEscapeDangerGoal(this, 1.7));
        this.field_6201.method_6277(2, (class_1352)new IntimidateMobsGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(4, (class_1352)new EatGoal(this));
        this.field_6201.method_6277(4, (class_1352)new StealItemGoal(this));
        this.field_6201.method_6277(5, (class_1352)new PickupFoodGoal(this));
        this.field_6201.method_6277(6, (class_1352)new GooseMeleeAttackGoal(this, 1.5, true));
        this.field_6201.method_6277(7, (class_1352)new class_1391((class_1314)this, 1.0, (Predicate)BREEDING_INGREDIENT, false));
        this.field_6201.method_6277(8, (class_1352)new WFollowParentGoal(this, 1.1));
        this.field_6201.method_6277(9, (class_1352)new class_1350((class_1321)this, 1.6, 10.0f, 2.0f));
        this.field_6201.method_6277(9, (class_1352)new CleanGoal(this));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new GooseRevengeGoal(this).method_6318(new Class[0]));
    }

    public boolean method_6481(class_1799 stack) {
        if (this.isAngry()) {
            return false;
        }
        if (this.method_6181()) {
            return TAMING_INGREDIENT.method_8093(stack) || BREEDING_INGREDIENT.method_8093(stack);
        }
        return BREEDING_INGREDIENT.method_8093(stack);
    }

    public void method_6116(class_1304 slot, class_1799 oldStack, class_1799 newStack) {
        class_1542 ie;
        UUID thrower;
        if (this.method_37908().field_9236) {
            return;
        }
        class_1297 holder = newStack.method_27319();
        if (holder != null && this.isAngry() && holder instanceof class_1542 && (thrower = this.getThrower(ie = (class_1542)holder)) != null) {
            this.method_29922();
        }
        super.method_6116(slot, oldStack, newStack);
    }

    private UUID getThrower(class_1542 ie) {
        class_2487 nbt = new class_2487();
        ie.method_5652(nbt);
        if (nbt.method_25928("Thrower")) {
            return nbt.method_25926("Thrower");
        }
        return null;
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236 && this.animationTimer > 0) {
            --this.animationTimer;
            if (this.animationTimer == 0) {
                this.setAnimation((byte)0);
            }
        }
    }

    @Override
    protected void handlePanicAnimation() {
        if (!this.panicked && (this.method_6032() < this.method_6063() / 2.0f || this.method_6109()) && (this.method_6065() != null || this.method_5809())) {
            this.setAnimation((byte)4);
            this.panicked = true;
        } else if (this.panicked && this.method_6065() == null && !this.method_5809()) {
            this.setAnimation((byte)0);
            this.panicked = false;
        }
    }

    @Override
    protected boolean tryTaming(class_1657 player, class_1799 stack) {
        if (this.isAngry()) {
            if (FOOD.method_8093(stack)) {
                class_1799 newStack = stack.method_7972();
                newStack.method_7939(1);
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                if (!this.method_24523(newStack).method_7960()) {
                    this.method_29922();
                }
            }
            return false;
        }
        return super.tryTaming(player, stack);
    }

    @Override
    protected boolean isTamableItem(class_1799 stack) {
        return TAMING_INGREDIENT.method_8093(stack);
    }

    @Override
    protected boolean isTamable(class_1657 player, class_1799 stack) {
        return super.isTamable(player, stack) && !this.method_29511();
    }

    public boolean isAngry() {
        return this.method_5968() != null;
    }

    public void method_29922() {
        this.method_6015(null);
        this.method_29513(null);
        this.method_5980(null);
        this.method_29514(0);
        this.method_37908().method_8421((class_1297)this, (byte)100);
    }

    public class_1799 method_24523(class_1799 equipment) {
        class_1304 equipmentSlot = class_1304.field_6173;
        class_1799 itemStack = this.method_6047();
        if (FOOD.method_8093(equipment) || this.method_5939(equipment)) {
            class_1542 itemEntity;
            if (!itemStack.method_7960() && (itemEntity = this.method_5775(itemStack)) != null) {
                itemEntity.method_6982(40);
            }
            this.method_24834(equipmentSlot, equipment);
            return equipment;
        }
        return class_1799.field_8037;
    }

    private boolean isWeapon(class_1799 stack) {
        return stack.method_31573(class_3489.field_42611) || stack.method_31573(class_3489.field_42612);
    }

    protected void method_5949(class_1542 item) {
        if (this.getThrower(item) == this.method_5667()) {
            return;
        }
        if (this.method_6181()) {
            class_1657 player;
            class_1297 class_12972 = item.method_24921();
            if (class_12972 instanceof class_1657 && this.method_6171((class_1309)(player = (class_1657)class_12972))) {
                super.method_5949(item);
            }
            return;
        }
        super.method_5949(item);
    }

    public boolean method_5939(class_1799 stack) {
        class_1799 mainHandStack = this.method_6047();
        if (this.isWeapon(stack)) {
            return this.method_6181() && this.method_35057() != null && this.method_6032() == this.method_6063();
        }
        if (!FOOD.method_8093(mainHandStack) && FOOD.method_8093(stack)) {
            return true;
        }
        if (mainHandStack.method_7960()) {
            return !stack.method_31574(ModItems.GOOSE_EGG.get());
        }
        return false;
    }

    public boolean method_5936() {
        if (this.method_6109()) {
            return false;
        }
        return super.method_5936();
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        GooseEntity gooseEntity = (GooseEntity)ModEntityTypes.getGoose().method_5883((class_1937)world);
        if (gooseEntity != null && entity instanceof GooseEntity) {
            GooseEntity goose = (GooseEntity)entity;
            if (this.field_5974.method_43056()) {
                gooseEntity.setVariant(this.getVariant());
            } else {
                gooseEntity.setVariant(goose.getVariant());
            }
            if (this.method_6181()) {
                gooseEntity.method_6174(this.method_6139());
                gooseEntity.method_6173(true, true);
            }
        }
        return gooseEntity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate);
        controller.setParticleKeyframeHandler((AnimationController.ParticleKeyframeHandler)this);
        controllerRegistrar.add(controller);
    }

    @Override
    protected class_3414 getLayEggSound() {
        return ModSoundEvents.GOOSE_LAY_EGG.get();
    }

    @Override
    public class_1792 getEggItem() {
        return ModItems.GOOSE_EGG.get();
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.method_5799();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.method_6172()) {
            controller.setAnimation(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 2: {
                controller.setAnimation(BITE_ANIM);
                this.animationTimer = 22;
                break;
            }
            case 6: {
                controller.setAnimation(INTIMIDATE_ANIM);
                break;
            }
            case 5: {
                controller.setAnimation(EAT_ANIM);
                break;
            }
            case 1: {
                controller.setAnimation(inWater ? SWIM_ANIM : CLEAN_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(HONK_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                if (this.method_6510()) {
                    controller.setAnimation(CHARGE_ANIM);
                    return PlayState.CONTINUE;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void method_5966() {
        if (this.method_6109()) {
            this.method_5783(ModSoundEvents.GOSLING_AMBIENT.get(), 0.3f, this.method_6017());
            return;
        }
        if (this.method_29511()) {
            this.method_5783(ModSoundEvents.GOOSE_HONK.get(), 0.6f, this.method_6017());
        }
    }

    @Nullable
    public class_1542 method_5699(class_1799 stack, float yOffset) {
        class_1542 droppedStack = super.method_5699(stack, yOffset);
        if (droppedStack == null) {
            return null;
        }
        droppedStack.method_6981((class_1297)this);
        return droppedStack;
    }

    protected void method_6013(class_1282 source) {
        if (this.method_6109()) {
            this.method_5783(ModSoundEvents.GOSLING_HURT.get(), 0.3f, this.method_6017() + 0.25f);
            return;
        }
        this.method_5783(ModSoundEvents.GOOSE_HONK.get(), 0.7f, this.method_6017());
    }

    @Nullable
    protected class_3414 method_6002() {
        if (this.method_6109()) {
            return ModSoundEvents.GOSLING_DEATH.get();
        }
        return ModSoundEvents.GOOSE_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(ModSoundEvents.DUCK_STEP.get(), 0.15f, 1.0f);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER_TIME);
    }

    public void method_29514(int ticks) {
        this.field_6011.method_12778(ANGER_TIME, (Object)ticks);
    }

    @Nullable
    public UUID method_29508() {
        return this.targetUuid;
    }

    public void method_29513(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public void handle(ParticleKeyframeEvent particleKeyframeEvent) {
        class_1799 stack = this.method_6047();
        if (stack == class_1799.field_8037) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            class_243 vel = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vel = vel.method_1037(-this.method_36455() * ((float)Math.PI / 180));
            vel = vel.method_1024(-this.method_36454() * ((float)Math.PI / 180));
            class_243 rotationVec = class_243.method_1030((float)0.0f, (float)this.field_6283);
            class_243 pos = new class_243(this.method_23317() + rotationVec.field_1352 / 2.0, this.method_23320() - 0.2, this.method_23321() + rotationVec.field_1350 / 2.0);
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, stack), pos.field_1352, pos.field_1351, pos.field_1350, vel.field_1352, vel.field_1351 + 0.05, vel.field_1350);
        }
    }

    public boolean wantsToPickupItem() {
        return !this.method_24345() && this.method_6065() == null && this.method_5968() == null;
    }

    @Override
    public boolean isHungry() {
        return this.isAngry() || super.isHungry();
    }

    public float method_17825() {
        if (UntitledConfig.gooseBabyRandomSize()) {
            float babyScale = this.getBabyScale();
            float modelScale = this.method_6109() ? babyScale : 0.8f + babyScale * 0.5f;
            return modelScale;
        }
        return super.method_17825();
    }

    static class GooseEscapeDangerGoal
    extends class_1374 {
        private final GooseEntity goose;

        public GooseEscapeDangerGoal(GooseEntity goose, double speed) {
            super((class_1314)goose, speed);
            this.goose = goose;
        }

        public boolean method_6264() {
            return (this.goose.method_6032() < this.goose.method_6063() / 2.0f || this.goose.method_6109()) && super.method_6264();
        }
    }

    static class IntimidateMobsGoal
    extends class_1352 {
        private static final int STARTING_DELAY = 10;
        private static final int ANIMATION_LENGTH = 25;
        private static final double INTIMIDATE_DISTANCE = 12.0;
        private final GooseEntity goose;
        private int animationTime;
        private int delayTime;
        private int cooldown;
        protected class_1297 targetEntity;
        private class_243 originalLocation;

        public IntimidateMobsGoal(GooseEntity goose) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
            this.goose = goose;
        }

        public boolean method_6264() {
            if (this.cooldown-- > 0) {
                return false;
            }
            if (this.goose.field_6012 % 5 == 0) {
                this.targetEntity = this.goose.method_37908().method_21726(class_1543.class, class_4051.method_36625(), (class_1309)this.goose, this.goose.method_23317(), this.goose.method_23318(), this.goose.method_23321(), this.goose.method_5829().method_1009(12.0, 3.0, 12.0));
                return this.targetEntity != null;
            }
            return false;
        }

        public void method_6269() {
            this.goose.method_5942().method_6340();
            this.animationTime = 25;
            this.delayTime = 10;
            this.originalLocation = this.goose.method_19538();
            this.goose.method_5942().method_6335(this.targetEntity, 1.2);
        }

        public void method_6270() {
            this.goose.setAnimation((byte)0);
            this.goose.method_5942().method_6337(this.originalLocation.field_1352, this.originalLocation.field_1351, this.originalLocation.field_1350, 1.2);
            this.cooldown = 20;
            this.targetEntity = null;
        }

        public boolean method_6266() {
            return this.targetEntity.method_5805() && this.goose.method_5707(this.originalLocation) <= 144.0 && this.animationTime >= 0;
        }

        public void method_6268() {
            this.goose.method_5988().method_20248(this.targetEntity.method_23317(), this.targetEntity.method_23320(), this.targetEntity.method_23321());
            if (this.delayTime > 0) {
                --this.delayTime;
                if (this.delayTime == 0) {
                    this.goose.method_5942().method_6340();
                    this.goose.setAnimation((byte)6);
                    this.goose.method_5783(ModSoundEvents.GOOSE_HONK.get(), 1.0f, 1.0f);
                }
                return;
            }
            --this.animationTime;
        }
    }

    static class StealItemGoal
    extends class_1352 {
        private static final double SPEED = 1.3;
        private final GooseEntity goose;
        class_1657 targetPlayer;
        int nextStealTime;
        private class_1799 playerHandStack;

        public StealItemGoal(GooseEntity goose) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            this.goose = goose;
            this.nextStealTime = goose.field_6012 + goose.method_59922().method_43048(1200) + 1200;
        }

        public boolean method_6264() {
            if (this.goose.method_6109() || this.goose.method_6181() || !this.goose.method_6047().method_7960()) {
                return false;
            }
            if (this.goose.field_6012 <= this.nextStealTime) {
                return false;
            }
            if (this.goose.method_59922().method_43048(10) != 0) {
                return false;
            }
            this.targetPlayer = this.goose.method_37908().method_18459(this.goose.method_23317(), this.goose.method_23318(), this.goose.method_23321(), 10.0, true);
            if (this.targetPlayer == null) {
                this.nextStealTime = this.goose.field_6012 + this.goose.method_59922().method_43048(200) + 200;
                return false;
            }
            this.playerHandStack = this.targetPlayer.method_6047();
            return FOOD.method_8093(this.playerHandStack);
        }

        public boolean method_6266() {
            if (this.targetPlayer == null) {
                return false;
            }
            this.playerHandStack = this.targetPlayer.method_6047();
            return FOOD.method_8093(this.playerHandStack);
        }

        public void method_6269() {
            this.goose.method_5942().method_6335((class_1297)this.targetPlayer, 1.3);
        }

        public void method_6270() {
            this.nextStealTime = this.goose.field_6012 + this.goose.method_59922().method_43048(1200) + 1200;
            this.targetPlayer = null;
        }

        public void method_6268() {
            if (this.goose.method_5739((class_1297)this.targetPlayer) <= 2.0f) {
                class_1799 stolenItemStack = this.playerHandStack.method_7972();
                stolenItemStack.method_7939(1);
                if (!this.goose.method_24523(stolenItemStack).method_7960()) {
                    this.playerHandStack.method_7934(1);
                }
                this.goose.method_6122(class_1268.field_5808, stolenItemStack);
                this.method_6270();
            } else {
                this.goose.method_5942().method_6335((class_1297)this.targetPlayer, 1.3);
            }
        }
    }

    static class PickupFoodGoal
    extends class_1352 {
        public static final double SPEED = 1.3;
        private final GooseEntity goose;
        private static final Predicate<class_1542> PICKABLE_DROP_FILTER = itemEntity -> !itemEntity.method_6977() && itemEntity.method_5805() && FOOD.method_8093(itemEntity.method_6983());

        public PickupFoodGoal(GooseEntity goose) {
            this.goose = goose;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.goose.method_6109() || !this.goose.method_6118(class_1304.field_6173).method_7960()) {
                return false;
            }
            if (!this.goose.wantsToPickupItem()) {
                return false;
            }
            if (this.goose.method_59922().method_43048(10) != 0) {
                return false;
            }
            List list = this.goose.method_37908().method_8390(class_1542.class, this.goose.method_5829().method_1009(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            return !list.isEmpty() && this.goose.method_6118(class_1304.field_6173).method_7960();
        }

        public void method_6268() {
            class_1799 itemStack = this.goose.method_6118(class_1304.field_6173);
            if (itemStack.method_7960()) {
                this.method_6269();
            }
        }

        public void method_6269() {
            List list = this.goose.method_37908().method_8390(class_1542.class, this.goose.method_5829().method_1009(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            if (!list.isEmpty()) {
                this.goose.method_5942().method_6335((class_1297)list.getFirst(), 1.3);
            }
        }
    }

    static class GooseMeleeAttackGoal
    extends class_1366 {
        private final GooseEntity goose;
        private static final int ANIMATION_LEN = 22;
        private static final int ANIMATION_ATTACK = 5;
        private int animationTimer = 0;

        public GooseMeleeAttackGoal(GooseEntity gooseEntity, double speed, boolean pauseWhenIdle) {
            super((class_1314)gooseEntity, speed, pauseWhenIdle);
            this.goose = gooseEntity;
        }

        public boolean method_6264() {
            return !this.goose.method_6109() && !this.goose.method_5799() && super.method_6264();
        }

        protected void method_6288(class_1309 target) {
            if (this.method_53715(target) && this.animationTimer <= 0) {
                this.goose.setAnimation((byte)2);
                this.animationTimer = 22;
                this.goose.method_5783(ModSoundEvents.GOOSE_HONK.get(), 0.8f, 1.2f);
            }
            if (this.animationTimer > 0) {
                --this.animationTimer;
                if (this.animationTimer == 5) {
                    this.field_6503.method_6121((class_1297)target);
                }
                if (this.animationTimer == 0) {
                    this.goose.setAnimation((byte)0);
                }
            }
        }

        public void method_6270() {
            super.method_6270();
            this.goose.setAnimation((byte)0);
            this.animationTimer = 0;
        }
    }

    static class CleanGoal
    extends class_1352 {
        private static final int ANIMATION_LENGTH = 32;
        private final GooseEntity goose;
        private int cleanTime;
        private int nextCleanTime;

        public CleanGoal(GooseEntity goose) {
            this.goose = goose;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
            this.nextCleanTime = goose.field_6012 + (200 + goose.method_59922().method_43048(10) * 20);
        }

        public boolean method_6264() {
            if (this.nextCleanTime > this.goose.field_6012 || this.goose.method_6131() >= 100 || this.goose.getAnimation() != 0) {
                return false;
            }
            return this.goose.method_59922().method_43048(40) == 0;
        }

        public void method_6269() {
            this.cleanTime = 32;
            this.goose.setAnimation((byte)1);
            this.nextCleanTime = this.goose.field_6012 + (200 + this.goose.method_59922().method_43048(10) * 20);
        }

        public void method_6270() {
            this.goose.setAnimation((byte)0);
        }

        public boolean method_6266() {
            return this.cleanTime >= 0;
        }

        public void method_6268() {
            --this.cleanTime;
        }
    }

    static class GooseRevengeGoal
    extends class_1399 {
        private final GooseEntity goose;

        public GooseRevengeGoal(GooseEntity goose) {
            super((class_1314)goose, new Class[0]);
            this.goose = goose;
        }

        public boolean method_6266() {
            return this.goose.method_5968() != null && super.method_6266();
        }
    }
}

