/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.platform.neoforge;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.untitledduckmod.DuckMod;
import net.untitledduckmod.common.entity.CustomSpawnGroup;
import net.untitledduckmod.common.entity.neoforge.DuckEntityForge;
import net.untitledduckmod.common.entity.neoforge.GooseEntityForge;

public class RegistryHelperImpl {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"untitledduckmod");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"untitledduckmod");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"untitledduckmod");
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((Registry)BuiltInRegistries.POTION, (String)"untitledduckmod");
    public static final DeferredRegister<MobEffect> STATUS_EFFECTS = DeferredRegister.create((Registry)BuiltInRegistries.MOB_EFFECT, (String)"untitledduckmod");
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"untitledduckmod");

    public static <T extends Item> Supplier<T> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    public static <T extends Item> Supplier<T> registerSpawnEggItem(String name, Supplier<? extends EntityType<? extends Mob>> type, int primaryColor, int secondaryColor, Item.Properties settings) {
        return RegistryHelperImpl.registerItem(name, () -> new DeferredSpawnEggItem(type, primaryColor, secondaryColor, settings));
    }

    public static <T extends EntityType<?>> Supplier<T> registerEntity(String name, Supplier<T> entityType) {
        if (name.equals("duck")) {
            entityType = () -> EntityType.Builder.of(DuckEntityForge::new, (MobCategory)CustomSpawnGroup.WATERFOWL.spawnGroup).sized(0.6f, 0.6f).clientTrackingRange(10).build(DuckMod.stringID("duck"));
        } else if (name.equals("goose")) {
            entityType = () -> EntityType.Builder.of(GooseEntityForge::new, (MobCategory)CustomSpawnGroup.WATERFOWL.spawnGroup).sized(0.7f, 1.2f).clientTrackingRange(10).build(DuckMod.stringID("goose"));
        }
        return ENTITY_TYPES.register(name, entityType);
    }

    public static Supplier<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)DuckMod.id(name)));
    }

    public static Holder<Potion> registerPotion(String name, Supplier<Potion> potion) {
        return POTIONS.register(name, potion);
    }

    public static Holder<MobEffect> registerStatusEffect(String name, Supplier<MobEffect> statusEffect) {
        return STATUS_EFFECTS.register(name, statusEffect);
    }

    public static <T extends MapCodec<? extends BiomeModifier>> void registerBiomeModifier(String name, Supplier<T> biomeModifier) {
        BIOME_MODIFIERS.register(name, biomeModifier);
    }
}

