/*
 * Decompiled with CFR 0.152.
 */
package easton.warppipes;

import com.google.common.collect.Maps;
import easton.warppipes.WarpPipesMod;
import easton.warppipes.mixin.ServerAccessor;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PipeUtil {
    public static Map<class_2248, List<class_2338>> blockPosMap = Maps.newHashMap();
    public static class_2248 lastBrokenBlock = null;

    public static void addNewPipe(class_1937 world, class_2338 pipePos, class_2680 pipeState) {
        class_2248 baseBlock = world.method_8320(pipePos.method_10093(((class_2350)pipeState.method_11654((class_2769)class_2318.field_10927)).method_10153())).method_26204();
        if (blockPosMap.containsKey(baseBlock)) {
            if (!blockPosMap.get(baseBlock).contains(pipePos)) {
                blockPosMap.get(baseBlock).add(pipePos);
            }
        } else {
            ArrayList<class_2338> list = new ArrayList<class_2338>();
            list.add(pipePos);
            blockPosMap.put(baseBlock, list);
        }
    }

    public static void removePipe(class_1936 world, class_2338 pipePos, class_2680 pipeState, @Nullable class_2248 base) {
        class_2248 baseBlock;
        class_2248 class_22482 = baseBlock = base == null ? world.method_8320(pipePos.method_10093(((class_2350)pipeState.method_11654((class_2769)class_2318.field_10927)).method_10153())).method_26204() : base;
        if (blockPosMap.containsKey(baseBlock)) {
            List<class_2338> list = blockPosMap.get(baseBlock);
            list.remove(pipePos);
            if (list.isEmpty()) {
                blockPosMap.remove(baseBlock);
            }
        }
    }

    public static void triggerTp(class_3222 player, class_3218 world, class_2338 pipePos, class_2338 blockPos) {
        List<class_2338> posList = blockPosMap.get(world.method_8320(blockPos).method_26204());
        if (posList == null) {
            return;
        }
        int i = posList.indexOf(pipePos);
        class_2338 target = posList.size() > i + 1 ? posList.get(i + 1) : posList.get(0);
        if (!world.method_8320(target).method_27852(WarpPipesMod.WARP_PIPE)) {
            PipeUtil.triggerTp(player, world, target, blockPos);
            return;
        }
        if (target.equals((Object)pipePos)) {
            return;
        }
        PipeUtil.tp(player, world, target);
    }

    private static void tp(class_3222 player, class_3218 world, class_2338 target) {
        class_2350 dir = (class_2350)world.method_8320(target).method_11654((class_2769)class_2318.field_10927);
        class_2338 tpPos = dir == class_2350.field_11033 ? target.method_10079(dir, 2) : target.method_10093(dir);
        class_1923 chunkPos = new class_1923(tpPos);
        world.method_14178().method_17297(class_3230.field_19347, chunkPos, 1, (Object)player.method_5628());
        player.method_5848();
        if (world == player.field_6002) {
            player.field_13987.method_14363((double)tpPos.method_10263() + 0.5, (double)tpPos.method_10264() + 0.5, (double)tpPos.method_10260() + 0.5, player.field_6241, player.method_36455());
        } else {
            player.method_14251(world, (double)tpPos.method_10263() + 0.5, (double)tpPos.method_10264() + 0.5, (double)tpPos.method_10260() + 0.5, player.field_6241, player.method_36455());
        }
    }

    public static void writeMapToFile(MinecraftServer server) throws IOException {
        File overworldFile = ((ServerAccessor)server).getSession().method_27424(class_3218.field_25179);
        File file = new File(overworldFile, "warp_pipes_data.txt");
        file.createNewFile();
        PrintStream out = new PrintStream(file);
        for (Map.Entry<class_2248, List<class_2338>> entry : blockPosMap.entrySet()) {
            out.println(entry.getKey() + "%" + entry.getValue());
        }
        out.close();
    }

    public static void readMapFromFile(MinecraftServer server) throws IOException {
        File overworldFile = ((ServerAccessor)server).getSession().method_27424(class_3218.field_25179);
        File file = new File(overworldFile, "warp_pipes_data.txt");
        file.createNewFile();
        Scanner scanner = new Scanner(file);
        HashMap<class_2248, List<class_2338>> map = new HashMap<class_2248, List<class_2338>>();
        while (scanner.hasNext()) {
            String s = scanner.nextLine();
            class_2248 block = PipeUtil.blockFromString(s.substring(0, s.indexOf(37)));
            List<class_2338> list = PipeUtil.listFromString(s.substring(s.indexOf(37) + 1));
            map.put(block, list);
        }
        scanner.close();
        blockPosMap = map;
    }

    public static class_2248 blockFromString(String s) {
        return (class_2248)class_2378.field_11146.method_10223(new class_2960(s.substring(s.indexOf(123) + 1, s.indexOf(125))));
    }

    public static List<class_2338> listFromString(String s) {
        int index = 0;
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        while (s.indexOf(123, index) != -1) {
            index = s.indexOf(123, index);
            int x = Integer.parseInt(s.substring(s.indexOf("x=", index) + 2, s.indexOf(44, index)));
            index = s.indexOf(121, index);
            int y = Integer.parseInt(s.substring(s.indexOf("y=", index) + 2, s.indexOf(44, index)));
            index = s.indexOf(122, index);
            int z = Integer.parseInt(s.substring(s.indexOf("z=", index) + 2, s.indexOf(125, index)));
            class_2338 pos = new class_2338(x, y, z);
            list.add(pos);
        }
        return list;
    }

    @Deprecated
    public static class_2248 getBaseBlock(class_1936 world, class_2338 pipePos, @Nullable class_2680 pipeState) {
        class_2680 state;
        class_2248 block = WarpPipesMod.WARP_PIPE;
        class_2680 class_26802 = state = pipeState == null ? world.method_8320(pipePos) : pipeState;
        while (block == WarpPipesMod.WARP_PIPE) {
            pipePos = pipePos.method_10093(((class_2350)state.method_11654((class_2769)class_2318.field_10927)).method_10153());
            block = world.method_8320(pipePos).method_26204();
        }
        return block;
    }
}

