/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutalib.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public abstract class BaseBakedModel
implements IDynamicBakedModel {
    protected void putVertex(BakedQuadBuilder builder, Vector3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite) {
        this.putVertex(builder, normal, x, y, z, u, v, sprite, 1.0f, 1.0f, 1.0f);
    }

    protected void putVertex(BakedQuadBuilder builder, Vector3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().func_227894_c_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.func_177369_e()) {
                        case 0: {
                            float iu = sprite.func_94214_a((double)u);
                            float iv = sprite.func_94207_b((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    protected static Vector3d v(double x, double y, double z) {
        return new Vector3d(x, y, z);
    }

    protected BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite) {
        return this.createQuad(v1, v2, v3, v4, sprite, false);
    }

    protected BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite, boolean reversed) {
        int u = sprite.func_94211_a();
        int v = sprite.func_94216_b();
        return this.createQuad(v1, v2, v3, v4, 0.0f, 0.0f, u, v, sprite, reversed);
    }

    protected BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, float uFrom, float vFrom, float uTo, float vTo, TextureAtlasSprite sprite) {
        return this.createQuad(v1, v2, v3, v4, uFrom, vFrom, uTo, vTo, sprite, false);
    }

    protected BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, float uFrom, float uTo, float vFrom, float vTo, TextureAtlasSprite sprite, boolean reversed) {
        Vector3d normal;
        Vector3d vector3d = normal = reversed ? v3.func_178788_d(v1).func_72431_c(v2.func_178788_d(v1)).func_72432_b() : v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        if (reversed) {
            Vector3d v0 = v1;
            v1 = v4;
            v4 = v0;
            v0 = v2;
            v2 = v3;
            v3 = v0;
        }
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, reversed ? uTo : uFrom, vFrom, sprite);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, reversed ? uTo : uFrom, vTo, sprite);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, reversed ? uFrom : uTo, vTo, sprite);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, reversed ? uFrom : uTo, vFrom, sprite);
        return builder.build();
    }

    protected List<BakedQuad> createCube(Vector3d from, Vector3d to, TextureAtlasSprite allFaces, boolean dynamicUV) {
        return this.createCube(from, to, allFaces, dynamicUV, false);
    }

    protected List<BakedQuad> createCube(Vector3d from, Vector3d to, TextureAtlasSprite allFaces, boolean dynamicUV, boolean withReversed) {
        return this.createCube(from, to, allFaces, allFaces, allFaces, allFaces, allFaces, allFaces, dynamicUV, withReversed);
    }

    protected List<BakedQuad> createCube(Vector3d from, Vector3d to, TextureAtlasSprite up, TextureAtlasSprite down, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite east, TextureAtlasSprite west, boolean dynamicUV) {
        return this.createCube(from, to, up, down, north, south, east, west, dynamicUV, false);
    }

    protected List<BakedQuad> createCube(Vector3d from, Vector3d to, TextureAtlasSprite up, TextureAtlasSprite down, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite east, TextureAtlasSprite west, boolean dynamicUV, boolean withReversed) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        double fx = from.func_82615_a();
        double fy = from.func_82617_b();
        double fz = from.func_82616_c();
        double tx = to.func_82615_a();
        double ty = to.func_82617_b();
        double tz = to.func_82616_c();
        quads.add(this.createQuad(BaseBakedModel.v(fx, ty, fz), BaseBakedModel.v(fx, ty, tz), BaseBakedModel.v(tx, ty, tz), BaseBakedModel.v(tx, ty, fz), this.getUFrom(dynamicUV, fx), this.getUTo(dynamicUV, tx), this.getVFrom(dynamicUV, fz), this.getVTo(dynamicUV, tz), up));
        quads.add(this.createQuad(BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(fx, fy, fz), this.getUFrom(dynamicUV, 1.0 - tx), this.getUTo(dynamicUV, 1.0 - fx), this.getVFrom(dynamicUV, fz), this.getVTo(dynamicUV, tz), down));
        quads.add(this.createQuad(BaseBakedModel.v(tx, ty, fz), BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(fx, fy, fz), BaseBakedModel.v(fx, ty, fz), this.getUFrom(dynamicUV, 1.0 - tx), this.getUTo(dynamicUV, 1.0 - fx), this.getVFrom(dynamicUV, 1.0 - ty), this.getVTo(dynamicUV, 1.0 - fy), north));
        quads.add(this.createQuad(BaseBakedModel.v(fx, ty, tz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(tx, ty, tz), this.getUFrom(dynamicUV, fx), this.getUTo(dynamicUV, tx), this.getVFrom(dynamicUV, 1.0 - ty), this.getVTo(dynamicUV, 1.0 - fy), south));
        quads.add(this.createQuad(BaseBakedModel.v(tx, ty, tz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(tx, ty, fz), this.getUFrom(dynamicUV, 1.0 - tz), this.getUTo(dynamicUV, 1.0 - fz), this.getVFrom(dynamicUV, 1.0 - ty), this.getVTo(dynamicUV, 1.0 - fy), east));
        quads.add(this.createQuad(BaseBakedModel.v(fx, ty, fz), BaseBakedModel.v(fx, fy, fz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(fx, ty, tz), this.getUFrom(dynamicUV, fz), this.getUTo(dynamicUV, tz), this.getVFrom(dynamicUV, 1.0 - ty), this.getVTo(dynamicUV, 1.0 - fy), west));
        if (withReversed) {
            quads.add(this.createQuad(BaseBakedModel.v(fx, ty, fz), BaseBakedModel.v(fx, ty, tz), BaseBakedModel.v(tx, ty, tz), BaseBakedModel.v(tx, ty, fz), this.getUFrom(dynamicUV, fx), this.getUTo(dynamicUV, tx), this.getVFrom(dynamicUV, fz), this.getVTo(dynamicUV, tz), up, true));
            quads.add(this.createQuad(BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(fx, fy, fz), this.getUFrom(dynamicUV, 1.0 - tx), this.getUTo(dynamicUV, 1.0 - fx), this.getVFrom(dynamicUV, fz), this.getVTo(dynamicUV, tz), down, true));
            quads.add(this.createQuad(BaseBakedModel.v(tx, ty, fz), BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(fx, fy, fz), BaseBakedModel.v(fx, ty, fz), this.getUFrom(dynamicUV, 1.0 - tx), this.getUTo(dynamicUV, 1.0 - fx), this.getVFrom(dynamicUV, 1.0 - ty), this.getVTo(dynamicUV, 1.0 - fy), north, true));
            quads.add(this.createQuad(BaseBakedModel.v(fx, ty, tz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(tx, ty, tz), this.getUFrom(dynamicUV, fx), this.getUTo(dynamicUV, tx), this.getVFrom(dynamicUV, 1.0 - ty), this.getVTo(dynamicUV, 1.0 - fy), south, true));
            quads.add(this.createQuad(BaseBakedModel.v(tx, ty, tz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(tx, ty, fz), this.getUFrom(dynamicUV, 1.0 - tz), this.getUTo(dynamicUV, 1.0 - fz), this.getVFrom(dynamicUV, 1.0 - ty), this.getVTo(dynamicUV, 1.0 - fy), east, true));
            quads.add(this.createQuad(BaseBakedModel.v(fx, ty, fz), BaseBakedModel.v(fx, fy, fz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(fx, ty, tz), this.getUFrom(dynamicUV, fz), this.getUTo(dynamicUV, tz), this.getVFrom(dynamicUV, 1.0 - ty), this.getVTo(dynamicUV, 1.0 - fy), west, true));
        }
        return quads;
    }

    private float getUFrom(boolean dynamicUV, double d) {
        return dynamicUV && 0.0 <= d && d <= 1.0 ? 16.0f * (float)d : 0.0f;
    }

    private float getUTo(boolean dynamicUV, double d) {
        return dynamicUV && 0.0 <= d && d <= 1.0 ? 16.0f * (float)d : 16.0f;
    }

    private float getVFrom(boolean dynamicUV, double d) {
        return dynamicUV && 0.0 <= d && d <= 1.0 ? 16.0f * (float)d : 0.0f;
    }

    private float getVTo(boolean dynamicUV, double d) {
        return dynamicUV && 0.0 <= d && d <= 1.0 ? 16.0f * (float)d : 16.0f;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

