/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutalib.datagen.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Function;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.extensions.IForgeTileEntity;
import org.jetbrains.annotations.NotNull;

public class NBTCondition
implements ILootCondition {
    public static final LootConditionType LOOT_CONDITION_TYPE = NBTCondition.register("nbt_condition", new Serializer());
    private static final Function<Entity, INBT> NBT_FROM_ENTITY = NBTPredicate::func_196981_b;
    private static final Function<TileEntity, INBT> NBT_FROM_TILE_ENTITY = IForgeTileEntity::serializeNBT;
    private final Source source;
    private final NBTPredicate nbtPredicate;

    private static LootConditionType register(String registryName, ILootSerializer<? extends ILootCondition> serializer) {
        return (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation("withoutalib", registryName), (Object)new LootConditionType(serializer));
    }

    public static void init() {
    }

    private NBTCondition(Source source, NBTPredicate nbtPredicate) {
        this.source = source;
        this.nbtPredicate = nbtPredicate;
    }

    @NotNull
    public LootConditionType func_230419_b_() {
        return LOOT_CONDITION_TYPE;
    }

    public boolean test(LootContext lootContext) {
        INBT nbt = this.source.nbtFunction.apply(lootContext);
        return this.nbtPredicate.func_193477_a(nbt);
    }

    public static Builder builder(Source source) {
        return new Builder(source);
    }

    static /* synthetic */ Function access$300() {
        return NBT_FROM_ENTITY;
    }

    static /* synthetic */ Function access$400() {
        return NBT_FROM_TILE_ENTITY;
    }

    public static enum Source {
        THIS("this", LootParameters.field_216281_a, NBTCondition.access$300()),
        KILLER("killer", LootParameters.field_216284_d, NBTCondition.access$300()),
        KILLER_PLAYER("killer_player", LootParameters.field_216282_b, NBTCondition.access$300()),
        BLOCK_ENTITY("block_entity", LootParameters.field_216288_h, NBTCondition.access$400());

        public final String sourceName;
        public final LootParameter<?> lootParam;
        public final Function<LootContext, INBT> nbtFunction;

        private <T> Source(String sourceName, LootParameter<T> lootParam, Function<? super T, INBT> nbtFunction) {
            this.sourceName = sourceName;
            this.lootParam = lootParam;
            this.nbtFunction = lootContext -> {
                Object t = lootContext.func_216031_c(lootParam);
                return t != null ? (INBT)nbtFunction.apply(t) : null;
            };
        }

        public static Source getByName(String sourceName) {
            for (Source source : Source.values()) {
                if (!source.sourceName.equals(sourceName)) continue;
                return source;
            }
            throw new IllegalArgumentException("Invalid tag source " + sourceName);
        }
    }

    public static class Serializer
    implements ILootSerializer<NBTCondition> {
        public void serialize(@NotNull JsonObject jsonObject, @NotNull NBTCondition nbtCondition, @NotNull JsonSerializationContext serializationContext) {
            jsonObject.addProperty("source", ((NBTCondition)nbtCondition).source.sourceName);
            jsonObject.add("nbt_predicate", nbtCondition.nbtPredicate.func_200322_a());
        }

        @NotNull
        public NBTCondition deserialize(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext deserializationContext) {
            Source source = Source.getByName(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"source"));
            NBTPredicate nbtPredicate = NBTPredicate.func_193476_a((JsonElement)jsonObject.get("nbt_predicate"));
            return new NBTCondition(source, nbtPredicate);
        }
    }

    public static class Builder
    implements ILootCondition.IBuilder {
        private final Source source;
        private NBTPredicate nbtPredicate = NBTPredicate.field_193479_a;

        public Builder(Source source) {
            this.source = source;
        }

        public Builder fromPredicate(NBTPredicate nbtPredicate) {
            this.nbtPredicate = nbtPredicate;
            return this;
        }

        @NotNull
        public ILootCondition build() {
            return new NBTCondition(this.source, this.nbtPredicate);
        }
    }
}

