/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutalib.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import withoutaname.mods.withoutalib.tools.VectorUtils;

public abstract class BaseBakedModel
implements IDynamicBakedModel {
    protected static Vector3f v(float x, float y, float z) {
        return new Vector3f(x, y, z);
    }

    protected void putVertex(BakedQuadBuilder builder, Vector3f normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite) {
        this.putVertex(builder, normal, x, y, z, u, v, sprite, 1.0f, 1.0f, 1.0f);
    }

    protected void putVertex(@Nonnull BakedQuadBuilder builder, Vector3f normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().m_86023_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.m_86048_()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.m_86049_()) {
                        case 0: {
                            float iu = sprite.m_118367_((double)u);
                            float iv = sprite.m_118393_((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{normal.m_122239_(), normal.m_122260_(), normal.m_122269_()});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    protected BakedQuad createQuad(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, TextureAtlasSprite sprite) {
        return this.createQuad(v1, v2, v3, v4, sprite, false);
    }

    protected BakedQuad createQuad(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, @Nonnull TextureAtlasSprite sprite, boolean reversed) {
        int u = sprite.m_118405_();
        int v = sprite.m_118408_();
        return this.createQuad(v1, v2, v3, v4, 0.0f, 0.0f, u, v, sprite, reversed);
    }

    protected BakedQuad createQuad(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, float uFrom, float vFrom, float uTo, float vTo, TextureAtlasSprite sprite) {
        return this.createQuad(v1, v2, v3, v4, uFrom, vFrom, uTo, vTo, sprite, false);
    }

    protected BakedQuad createQuad(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, float uFrom, float uTo, float vFrom, float vTo, TextureAtlasSprite sprite, boolean reversed) {
        Vector3f normal;
        Vector3f vector3f = normal = reversed ? VectorUtils.cross(VectorUtils.subtract(v3, v1), VectorUtils.subtract(v2, v1)) : VectorUtils.cross(VectorUtils.subtract(v3, v2), VectorUtils.subtract(v1, v2));
        if (reversed) {
            Vector3f v0 = v1;
            v1 = v4;
            v4 = v0;
            v0 = v2;
            v2 = v3;
            v3 = v0;
        }
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.m_122372_((float)normal.m_122239_(), (float)normal.m_122260_(), (float)normal.m_122269_()));
        this.putVertex(builder, normal, v1.m_122239_(), v1.m_122260_(), v1.m_122269_(), reversed ? uTo : uFrom, vFrom, sprite);
        this.putVertex(builder, normal, v2.m_122239_(), v2.m_122260_(), v2.m_122269_(), reversed ? uTo : uFrom, vTo, sprite);
        this.putVertex(builder, normal, v3.m_122239_(), v3.m_122260_(), v3.m_122269_(), reversed ? uFrom : uTo, vTo, sprite);
        this.putVertex(builder, normal, v4.m_122239_(), v4.m_122260_(), v4.m_122269_(), reversed ? uFrom : uTo, vFrom, sprite);
        return builder.build();
    }

    protected List<BakedQuad> createCube(Vector3f from, Vector3f to, TextureAtlasSprite allFaces, boolean dynamicUV) {
        return this.createCube(from, to, allFaces, dynamicUV, false);
    }

    protected List<BakedQuad> createCube(Vector3f from, Vector3f to, TextureAtlasSprite allFaces, boolean dynamicUV, boolean withReversed) {
        return this.createCube(from, to, allFaces, allFaces, allFaces, allFaces, allFaces, allFaces, dynamicUV, withReversed);
    }

    protected List<BakedQuad> createCube(Vector3f from, Vector3f to, TextureAtlasSprite up, TextureAtlasSprite down, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite east, TextureAtlasSprite west, boolean dynamicUV) {
        return this.createCube(from, to, up, down, north, south, east, west, dynamicUV, false);
    }

    protected List<BakedQuad> createCube(@Nonnull Vector3f from, @Nonnull Vector3f to, TextureAtlasSprite up, TextureAtlasSprite down, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite east, TextureAtlasSprite west, boolean dynamicUV, boolean withReversed) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float fx = from.m_122239_();
        float fy = from.m_122260_();
        float fz = from.m_122269_();
        float tx = to.m_122239_();
        float ty = to.m_122260_();
        float tz = to.m_122269_();
        quads.add(this.createQuad(BaseBakedModel.v(fx, ty, fz), BaseBakedModel.v(fx, ty, tz), BaseBakedModel.v(tx, ty, tz), BaseBakedModel.v(tx, ty, fz), this.getUFrom(dynamicUV, fx), this.getUTo(dynamicUV, tx), this.getVFrom(dynamicUV, fz), this.getVTo(dynamicUV, tz), up));
        quads.add(this.createQuad(BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(fx, fy, fz), this.getUFrom(dynamicUV, 1.0f - tx), this.getUTo(dynamicUV, 1.0f - fx), this.getVFrom(dynamicUV, fz), this.getVTo(dynamicUV, tz), down));
        quads.add(this.createQuad(BaseBakedModel.v(tx, ty, fz), BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(fx, fy, fz), BaseBakedModel.v(fx, ty, fz), this.getUFrom(dynamicUV, 1.0f - tx), this.getUTo(dynamicUV, 1.0f - fx), this.getVFrom(dynamicUV, 1.0f - ty), this.getVTo(dynamicUV, 1.0f - fy), north));
        quads.add(this.createQuad(BaseBakedModel.v(fx, ty, tz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(tx, ty, tz), this.getUFrom(dynamicUV, fx), this.getUTo(dynamicUV, tx), this.getVFrom(dynamicUV, 1.0f - ty), this.getVTo(dynamicUV, 1.0f - fy), south));
        quads.add(this.createQuad(BaseBakedModel.v(tx, ty, tz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(tx, ty, fz), this.getUFrom(dynamicUV, 1.0f - tz), this.getUTo(dynamicUV, 1.0f - fz), this.getVFrom(dynamicUV, 1.0f - ty), this.getVTo(dynamicUV, 1.0f - fy), east));
        quads.add(this.createQuad(BaseBakedModel.v(fx, ty, fz), BaseBakedModel.v(fx, fy, fz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(fx, ty, tz), this.getUFrom(dynamicUV, fz), this.getUTo(dynamicUV, tz), this.getVFrom(dynamicUV, 1.0f - ty), this.getVTo(dynamicUV, 1.0f - fy), west));
        if (withReversed) {
            quads.add(this.createQuad(BaseBakedModel.v(fx, ty, fz), BaseBakedModel.v(fx, ty, tz), BaseBakedModel.v(tx, ty, tz), BaseBakedModel.v(tx, ty, fz), this.getUFrom(dynamicUV, fx), this.getUTo(dynamicUV, tx), this.getVFrom(dynamicUV, fz), this.getVTo(dynamicUV, tz), up, true));
            quads.add(this.createQuad(BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(fx, fy, fz), this.getUFrom(dynamicUV, 1.0f - tx), this.getUTo(dynamicUV, 1.0f - fx), this.getVFrom(dynamicUV, fz), this.getVTo(dynamicUV, tz), down, true));
            quads.add(this.createQuad(BaseBakedModel.v(tx, ty, fz), BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(fx, fy, fz), BaseBakedModel.v(fx, ty, fz), this.getUFrom(dynamicUV, 1.0f - tx), this.getUTo(dynamicUV, 1.0f - fx), this.getVFrom(dynamicUV, 1.0f - ty), this.getVTo(dynamicUV, 1.0f - fy), north, true));
            quads.add(this.createQuad(BaseBakedModel.v(fx, ty, tz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(tx, ty, tz), this.getUFrom(dynamicUV, fx), this.getUTo(dynamicUV, tx), this.getVFrom(dynamicUV, 1.0f - ty), this.getVTo(dynamicUV, 1.0f - fy), south, true));
            quads.add(this.createQuad(BaseBakedModel.v(tx, ty, tz), BaseBakedModel.v(tx, fy, tz), BaseBakedModel.v(tx, fy, fz), BaseBakedModel.v(tx, ty, fz), this.getUFrom(dynamicUV, 1.0f - tz), this.getUTo(dynamicUV, 1.0f - fz), this.getVFrom(dynamicUV, 1.0f - ty), this.getVTo(dynamicUV, 1.0f - fy), east, true));
            quads.add(this.createQuad(BaseBakedModel.v(fx, ty, fz), BaseBakedModel.v(fx, fy, fz), BaseBakedModel.v(fx, fy, tz), BaseBakedModel.v(fx, ty, tz), this.getUFrom(dynamicUV, fz), this.getUTo(dynamicUV, tz), this.getVFrom(dynamicUV, 1.0f - ty), this.getVTo(dynamicUV, 1.0f - fy), west, true));
        }
        return quads;
    }

    private float getUFrom(boolean dynamicUV, double d) {
        return dynamicUV && 0.0 <= d && d <= 1.0 ? 16.0f * (float)d : 0.0f;
    }

    private float getUTo(boolean dynamicUV, double d) {
        return dynamicUV && 0.0 <= d && d <= 1.0 ? 16.0f * (float)d : 16.0f;
    }

    private float getVFrom(boolean dynamicUV, double d) {
        return dynamicUV && 0.0 <= d && d <= 1.0 ? 16.0f * (float)d : 0.0f;
    }

    private float getVTo(boolean dynamicUV, double d) {
        return dynamicUV && 0.0 <= d && d <= 1.0 ? 16.0f * (float)d : 16.0f;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

