/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutalib.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    protected abstract void addTables();

    protected void createStandardTable(BlockItem blockItem) {
        this.createStandardTable(blockItem.m_40614_(), (ItemLike)blockItem);
    }

    protected void createStandardTable(Block block, ItemLike loot) {
        this.lootTables.put(block, this.getStandardLootTable(this.getStandardLootPool(block.getRegistryName().toString(), (LootPoolEntryContainer.Builder<?>)this.getStandardItemLootEntry(loot))));
    }

    protected LootTable.Builder getStandardLootTable(LootPool.Builder lootPoolIn) {
        return LootTable.m_79147_().m_79161_(lootPoolIn);
    }

    protected LootPool.Builder getStandardLootPool(String name, LootPoolEntryContainer.Builder<?> entriesBuilder) {
        return LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(entriesBuilder).m_6509_(ExplosionCondition.m_81661_());
    }

    protected LootPoolSingletonContainer.Builder<?> getStandardItemLootEntry(ItemLike itemIn) {
        return LootItem.m_79579_((ItemLike)itemIn);
    }

    public void m_6865_(@Nonnull HashCache cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().m_60589_(), entry.getValue().m_79165_(LootContextParamSets.f_81421_).m_79167_());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(HashCache cache, @Nonnull Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.m_123916_();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.m_135827_() + "/loot_tables/" + key.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }

    @Nonnull
    public String m_6055_() {
        return "LootTables";
    }
}

