/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutalib.datagen.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Registry;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;

public class NbtCondition
implements LootItemCondition {
    public static final LootItemConditionType LOOT_CONDITION_TYPE = NbtCondition.register();
    private final NbtProvider nbtProvider;
    private final NbtPredicate nbtPredicate;

    private NbtCondition(NbtProvider nbtProvider, NbtPredicate nbtPredicate) {
        this.nbtProvider = nbtProvider;
        this.nbtPredicate = nbtPredicate;
    }

    @Nonnull
    private static LootItemConditionType register() {
        return (LootItemConditionType)Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("withoutalib", "nbt_condition"), (Object)new LootItemConditionType((Serializer)new NbtConditionSerializer()));
    }

    public static void init() {
    }

    public static LootItemCondition.Builder create(NbtProvider nbtProvider, NbtPredicate predicate) {
        return () -> new NbtCondition(nbtProvider, predicate);
    }

    public static LootItemCondition.Builder create(LootContext.EntityTarget entityTarget, NbtPredicate predicate) {
        return () -> new NbtCondition(ContextNbtProvider.m_165570_((LootContext.EntityTarget)entityTarget), predicate);
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return LOOT_CONDITION_TYPE;
    }

    public boolean test(LootContext lootContext) {
        Tag nbt = this.nbtProvider.m_142301_(lootContext);
        return this.nbtPredicate.m_57483_(nbt);
    }

    public static class NbtConditionSerializer
    implements Serializer<NbtCondition> {
        public void serialize(@Nonnull JsonObject jsonObject, @Nonnull NbtCondition nbtCondition, @Nonnull JsonSerializationContext serializationContext) {
            jsonObject.add("source", serializationContext.serialize((Object)nbtCondition.nbtProvider));
            jsonObject.add("nbt_predicate", nbtCondition.nbtPredicate.m_57476_());
        }

        @Nonnull
        public NbtCondition deserialize(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext deserializationContext) {
            NbtProvider nbtProvider = (NbtProvider)GsonHelper.m_13836_((JsonObject)jsonObject, (String)"source", (JsonDeserializationContext)deserializationContext, NbtProvider.class);
            NbtPredicate nbtPredicate = NbtPredicate.m_57481_((JsonElement)jsonObject.get("nbt_predicate"));
            return new NbtCondition(nbtProvider, nbtPredicate);
        }
    }
}

