/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.blocks;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import withoutaname.mods.withoutalib.blocks.BaseContainer;
import withoutaname.mods.withoutawallpaper.blocks.PastingTableEntity;
import withoutaname.mods.withoutawallpaper.setup.Registration;
import withoutaname.mods.withoutawallpaper.tools.WallpaperDesign;
import withoutaname.mods.withoutawallpaper.tools.WallpaperType;

public class PastingTableContainer
extends BaseContainer {
    private final BlockEntity tileEntity;
    private final Player playerEntity;
    private Slot paperSlot;
    private Slot dyeSlot0;
    private Slot dyeSlot1;
    private Slot dyeSlot2;
    private Slot outputSlot;

    public PastingTableContainer(int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)Registration.PASTING_TABLE_CONTAINER.get(), windowId, 5);
        this.tileEntity = world.m_7702_(pos);
        this.playerEntity = player;
        InvWrapper playerInventory1 = new InvWrapper((Container)playerInventory);
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                this.paperSlot = this.m_38897_((Slot)new SlotItemHandler(handler, 0, 12, 20));
                this.dyeSlot0 = this.m_38897_((Slot)new SlotItemHandler(handler, 1, 42, 20));
                this.dyeSlot1 = this.m_38897_((Slot)new SlotItemHandler(handler, 2, 64, 20));
                this.dyeSlot2 = this.m_38897_((Slot)new SlotItemHandler(handler, 3, 86, 20));
            });
            this.outputSlot = this.m_38897_(new Slot((Container)new SimpleContainer(1), 0, 12, 60){

                public boolean m_5857_(@Nonnull ItemStack stack) {
                    return false;
                }

                public void m_142406_(@Nonnull Player thePlayer, @Nonnull ItemStack stack) {
                    CompoundTag tag = stack.m_41783_();
                    assert (tag != null);
                    WallpaperType wallpaperType = WallpaperType.fromNBT(tag.m_128469_("wallpaperType"));
                    PastingTableContainer.this.paperSlot.m_6201_(1);
                    if (wallpaperType.getDesign().getColorCount() > 0) {
                        PastingTableContainer.this.dyeSlot0.m_6201_(1);
                    }
                    if (wallpaperType.getDesign().getColorCount() > 1) {
                        PastingTableContainer.this.dyeSlot1.m_6201_(1);
                    }
                    if (wallpaperType.getDesign().getColorCount() > 2) {
                        PastingTableContainer.this.dyeSlot2.m_6201_(1);
                    }
                    super.m_142406_(thePlayer, stack);
                }
            });
            if (this.tileEntity instanceof PastingTableEntity) {
                final PastingTableEntity rollingStationTile = (PastingTableEntity)this.tileEntity;
                this.m_38895_(new DataSlot(){

                    public int m_6501_() {
                        return rollingStationTile.getSelectedWallpaperDesign().toInt();
                    }

                    public void m_6422_(int value) {
                        rollingStationTile.setSelectedWallpaperDesign(WallpaperDesign.fromInt(value));
                    }
                });
                rollingStationTile.addWallpaperChangedListener(this, this::updateOutput);
                this.updateOutput(rollingStationTile.getWallpaperType());
            }
        }
        this.addPlayerInventorySlots((IItemHandler)playerInventory1, 8, 95);
    }

    private void updateOutput(WallpaperType wallpaperType) {
        if (wallpaperType.getDesign() != WallpaperDesign.NONE && this.paperSlot.m_6657_()) {
            ItemStack itemStack = new ItemStack((ItemLike)Registration.WALLPAPER_ITEM.get());
            itemStack.m_41784_().m_128365_("wallpaperType", (Tag)wallpaperType.toNBT());
            itemStack.m_41764_(8);
            this.outputSlot.m_5852_(itemStack);
        } else {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        }
    }

    public boolean m_6366_(@Nonnull Player playerIn, int id) {
        if (this.tileEntity instanceof PastingTableEntity) {
            ((PastingTableEntity)this.tileEntity).setSelectedWallpaperDesign(id >= 0 && id < WallpaperDesign.getValuesExceptNone().size() ? WallpaperDesign.getValuesExceptNone().get(id) : WallpaperDesign.NONE);
            return true;
        }
        return false;
    }

    public WallpaperDesign getSelectedWallpaperDesign() {
        return ((PastingTableEntity)this.tileEntity).getSelectedWallpaperDesign();
    }

    public void m_6877_(@Nonnull Player playerIn) {
        if (this.tileEntity != null && this.tileEntity instanceof PastingTableEntity) {
            ((PastingTableEntity)this.tileEntity).removeWallpaperChangedListener(this);
        }
        super.m_6877_(playerIn);
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        Level level = this.tileEntity.m_58904_();
        assert (level != null);
        return PastingTableContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)level, (BlockPos)this.tileEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)Registration.PASTING_TABLE_BLOCK.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getPaperSlot() {
        return this.paperSlot;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getDyeSlot0() {
        return this.dyeSlot0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getDyeSlot1() {
        return this.dyeSlot1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getDyeSlot2() {
        return this.dyeSlot2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getOutputSlot() {
        return this.outputSlot;
    }
}

