/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import withoutaname.mods.withoutawallpaper.blocks.PastingTableContainer;
import withoutaname.mods.withoutawallpaper.setup.Registration;
import withoutaname.mods.withoutawallpaper.tools.WallpaperDesign;
import withoutaname.mods.withoutawallpaper.tools.WallpaperType;

public class PastingTableEntity
extends BlockEntity {
    private final HashMap<PastingTableContainer, Consumer<WallpaperType>> wallpaperChangedListeners = new HashMap();
    private WallpaperDesign selectedWallpaperDesign = WallpaperDesign.NONE;
    private WallpaperType wallpaperType = WallpaperType.NONE;
    private final ItemStackHandler itemHandler = this.createInputHandler();
    private final LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemHandler);

    public PastingTableEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.PASTING_TABLE_TILE.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.itemHandlerLazyOptional.invalidate();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_().m_142082_(1, 1, 1));
    }

    private void updateWallpaper() {
        boolean validWallpaperType = true;
        ArrayList<DyeColor> colors = new ArrayList<DyeColor>();
        for (int i = 1; i <= this.selectedWallpaperDesign.getColorCount(); ++i) {
            DyeColor color = DyeColor.getColor((ItemStack)this.itemHandler.getStackInSlot(i));
            colors.add(color);
            if (this.selectedWallpaperDesign.getAvailableColors()[i - 1].getColors().contains(color)) continue;
            validWallpaperType = false;
            break;
        }
        this.wallpaperType = validWallpaperType ? new WallpaperType(this.selectedWallpaperDesign, colors) : WallpaperType.NONE;
        this.wallpaperChangedListeners.forEach((rollingStationContainer, wallpaperTypeConsumer) -> wallpaperTypeConsumer.accept(this.wallpaperType));
    }

    public void addWallpaperChangedListener(PastingTableContainer container, Consumer<WallpaperType> wallpaperChangedListener) {
        this.wallpaperChangedListeners.put(container, wallpaperChangedListener);
    }

    public void removeWallpaperChangedListener(PastingTableContainer container) {
        this.wallpaperChangedListeners.remove((Object)container);
    }

    public WallpaperDesign getSelectedWallpaperDesign() {
        return this.selectedWallpaperDesign;
    }

    public void setSelectedWallpaperDesign(WallpaperDesign wallpaperDesign) {
        this.selectedWallpaperDesign = wallpaperDesign;
        this.update();
    }

    public void update() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.m_5776_()) {
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            }
            this.updateWallpaper();
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.writeData(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readData(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        this.readData(nbt);
        super.m_142466_(nbt);
        this.update();
    }

    private void readData(CompoundTag nbt) {
        this.itemHandler.deserializeNBT(nbt.m_128469_("inv"));
        try {
            this.selectedWallpaperDesign = WallpaperDesign.fromString(nbt.m_128461_("selectedDesign"));
        }
        catch (IllegalArgumentException e) {
            this.selectedWallpaperDesign = WallpaperDesign.NONE;
        }
        this.updateWallpaper();
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag nbt) {
        this.writeData(nbt);
        return super.m_6945_(nbt);
    }

    private void writeData(CompoundTag nbt) {
        nbt.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128359_("selectedDesign", this.selectedWallpaperDesign.toString());
    }

    private ItemStackHandler createInputHandler() {
        return new ItemStackHandler(4){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return stack.m_41720_() == Items.f_42516_;
                }
                if (slot <= PastingTableEntity.this.selectedWallpaperDesign.getColorCount()) {
                    return PastingTableEntity.this.selectedWallpaperDesign.getAvailableColors()[slot - 1].getColors().contains(DyeColor.getColor((ItemStack)stack));
                }
                return false;
            }

            protected void onContentsChanged(int slot) {
                PastingTableEntity.this.update();
            }
        };
    }

    public DyeColor[] getColors() {
        return new DyeColor[]{DyeColor.getColor((ItemStack)this.itemHandler.getStackInSlot(1)), DyeColor.getColor((ItemStack)this.itemHandler.getStackInSlot(2)), DyeColor.getColor((ItemStack)this.itemHandler.getStackInSlot(3))};
    }

    public WallpaperType getWallpaperType() {
        return this.wallpaperType;
    }

    public boolean hasPaper() {
        return !this.itemHandler.getStackInSlot(0).m_41619_();
    }
}

