/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import withoutaname.mods.withoutalib.blocks.BaseBakedModel;
import withoutaname.mods.withoutawallpaper.blocks.WallpaperEntity;

public class WallpaperBakedModel
extends BaseBakedModel {
    public static final ResourceLocation PARTICLE_TEXTURE = new ResourceLocation("withoutawallpaper", "block/wallpaper/particles");

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (side != null || layer != null && !layer.equals(RenderType.m_110466_())) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        HashMap designs = (HashMap)extraData.getData(WallpaperEntity.DESIGNS);
        if (designs != null) {
            float thickness = 0.00625f;
            designs.forEach((direction, wallpaperType) -> {
                for (TextureAtlasSprite textureAtlasSprite : wallpaperType.getAtlasSprites()) {
                    switch (direction) {
                        case UP: {
                            quads.addAll(this.createCube(WallpaperBakedModel.v((float)0.0f, (float)0.99375f, (float)0.0f), WallpaperBakedModel.v((float)1.0f, (float)1.0f, (float)1.0f), textureAtlasSprite, true));
                            break;
                        }
                        case DOWN: {
                            quads.addAll(this.createCube(WallpaperBakedModel.v((float)0.0f, (float)0.0f, (float)0.0f), WallpaperBakedModel.v((float)1.0f, (float)0.00625f, (float)1.0f), textureAtlasSprite, true));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(this.createCube(WallpaperBakedModel.v((float)0.0f, (float)0.0f, (float)0.0f), WallpaperBakedModel.v((float)1.0f, (float)1.0f, (float)0.00625f), textureAtlasSprite, true));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(this.createCube(WallpaperBakedModel.v((float)0.0f, (float)0.0f, (float)0.99375f), WallpaperBakedModel.v((float)1.0f, (float)1.0f, (float)1.0f), textureAtlasSprite, true));
                            break;
                        }
                        case EAST: {
                            quads.addAll(this.createCube(WallpaperBakedModel.v((float)0.99375f, (float)0.0f, (float)0.0f), WallpaperBakedModel.v((float)1.0f, (float)1.0f, (float)1.0f), textureAtlasSprite, true));
                            break;
                        }
                        case WEST: {
                            quads.addAll(this.createCube(WallpaperBakedModel.v((float)0.0f, (float)0.0f, (float)0.0f), WallpaperBakedModel.v((float)0.00625f, (float)1.0f, (float)1.0f), textureAtlasSprite, true));
                        }
                    }
                }
            });
        }
        return quads;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(PARTICLE_TEXTURE);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7521_() {
        return true;
    }
}

