/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.blocks;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import withoutaname.mods.withoutawallpaper.setup.Registration;
import withoutaname.mods.withoutawallpaper.tools.WallpaperType;

public class WallpaperEntity
extends BlockEntity {
    public static final ModelProperty<HashMap<Direction, WallpaperType>> DESIGNS = new ModelProperty();
    private final HashMap<Direction, WallpaperType> designs = new HashMap();

    public WallpaperEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.WALLPAPER_TILE.get(), pos, state);
        for (Direction direction : Direction.values()) {
            this.designs.put(direction, WallpaperType.NONE);
        }
    }

    public WallpaperType getType(Direction direction) {
        return this.designs.get(direction);
    }

    public void setType(Direction direction, WallpaperType wallpaperType) {
        this.designs.put(direction, wallpaperType);
        this.update();
    }

    public void update() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_5776_()) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
            } else {
                this.m_6596_();
            }
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.writeDesigns(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readDesigns(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DESIGNS, this.designs).build();
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readDesigns(nbt);
    }

    private void readDesigns(CompoundTag nbt) {
        for (Direction direction : Direction.values()) {
            if (!nbt.m_128441_(direction.toString())) continue;
            this.designs.put(direction, WallpaperType.fromNBT(nbt.m_128469_(direction.toString())));
        }
        this.update();
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag nbt) {
        this.writeDesigns(nbt);
        return super.m_6945_(nbt);
    }

    private void writeDesigns(CompoundTag nbt) {
        this.designs.forEach((direction, wallpaperType) -> nbt.m_128365_(direction.toString(), (Tag)wallpaperType.toNBT()));
    }
}

