/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import withoutaname.mods.withoutawallpaper.gui.WallpaperWidget;
import withoutaname.mods.withoutawallpaper.gui.colorselection.ColorButton;
import withoutaname.mods.withoutawallpaper.gui.colorselection.ColorSelectionScreen;
import withoutaname.mods.withoutawallpaper.gui.designselection.DesignSelectionWidget;
import withoutaname.mods.withoutawallpaper.gui.designselection.IDesignSelectable;
import withoutaname.mods.withoutawallpaper.tools.Colors;
import withoutaname.mods.withoutawallpaper.tools.WallpaperDesign;
import withoutaname.mods.withoutawallpaper.tools.WallpaperType;

public class WallpaperCatalogGUI
extends Screen
implements IDesignSelectable {
    protected final ResourceLocation GUI_TEXTURE = new ResourceLocation("withoutawallpaper", "textures/gui/wallpaper_catalog.png");
    private final int xSize = 156;
    private final int ySize = 106;
    private int guiLeft;
    private int guiTop;
    private final DyeColor[] colors = new DyeColor[3];
    private WallpaperDesign design = WallpaperDesign.NONE;
    private WallpaperType type = WallpaperType.NONE;

    public WallpaperCatalogGUI() {
        super((Component)new TranslatableComponent("screen.withoutawallpaper.wallpaper_catalog"));
    }

    protected void m_7856_() {
        this.guiLeft = (this.f_96543_ - 156) / 2;
        this.guiTop = (this.f_96544_ - 106) / 2;
        for (int i = 0; i < 3; ++i) {
            int finalI = i;
            this.m_142416_((GuiEventListener)new ColorButton(this.guiLeft + 10 + i * 24, this.guiTop + 10, () -> this.colors[finalI], button -> {
                assert (this.f_96541_ != null);
                Colors[] availableColors = this.design.getAvailableColors();
                ArrayList<DyeColor> colors = availableColors.length > finalI ? availableColors[finalI].getColors() : new ArrayList();
                this.f_96541_.m_91152_((Screen)new ColorSelectionScreen(this, colors, color -> {
                    this.colors[finalI] = color;
                    this.updateType();
                }));
            }, this));
        }
        this.m_142416_((GuiEventListener)new WallpaperWidget(this.guiLeft + 16, this.guiTop + 40, 56, () -> this.type));
        this.m_142416_((GuiEventListener)new DesignSelectionWidget(this.guiLeft + 89, this.guiTop + 11, 2, 4, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, this));
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.drawGuiBackgroundLayer(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void drawGuiBackgroundLayer(PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI_TEXTURE);
        int i = this.guiLeft;
        int j = this.guiTop;
        this.m_93228_(matrixStack, i, j, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public WallpaperDesign getDesign() {
        return this.design;
    }

    @Override
    public void setDesign(@Nonnull WallpaperDesign design) {
        this.design = design;
        Colors[] availableColors = design.getAvailableColors();
        for (int i = 0; i < 3; ++i) {
            if (i < availableColors.length) {
                if (availableColors[i].getColors().contains(this.colors[i])) continue;
                this.colors[i] = availableColors[i].getColors().get(0);
                continue;
            }
            this.colors[i] = null;
        }
        this.updateType();
    }

    private void updateType() {
        this.type = new WallpaperType(this.design, Arrays.copyOf(this.colors, this.design.getColorCount()));
    }

    public boolean m_7043_() {
        return false;
    }

    public static void open() {
        Minecraft.m_91087_().m_91152_((Screen)new WallpaperCatalogGUI());
    }
}

