/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.gui.designselection;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import withoutaname.mods.withoutawallpaper.gui.designselection.DesignButton;
import withoutaname.mods.withoutawallpaper.gui.designselection.IDesignSelectable;
import withoutaname.mods.withoutawallpaper.tools.WallpaperDesign;

public class DesignSelectionWidget
extends AbstractWidget {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("withoutawallpaper", "textures/gui/container/pasting_table.png");
    private final int designsPerRow;
    private final int designsPerCollum;
    private final DesignButton[] buttons;
    private final int rowsCount;
    private final boolean scrollable;
    private int selectedRow = 0;
    private int scrolledY = 0;
    private boolean isScrolling = false;

    public DesignSelectionWidget(int x, int y, int designsPerRow, int designsPerCollum, Consumer<AbstractWidget> widgetConsumer, IDesignSelectable designSelectable) {
        super(x, y, designsPerRow * 21 + 14, designsPerCollum * 21, TextComponent.f_131282_);
        this.designsPerRow = designsPerRow;
        this.designsPerCollum = designsPerCollum;
        this.rowsCount = (int)Math.ceil((double)WallpaperDesign.getValuesExceptNone().size() / (double)designsPerRow);
        this.scrollable = this.rowsCount > designsPerCollum;
        this.buttons = new DesignButton[designsPerRow * designsPerCollum];
        for (int i = 0; i < designsPerRow; ++i) {
            for (int j = 0; j < designsPerCollum; ++j) {
                this.buttons[i + j * designsPerRow] = new DesignButton(x + i * 21, y + j * 21, designSelectable, WallpaperDesign.NONE);
                widgetConsumer.accept((AbstractWidget)this.buttons[i + j * designsPerRow]);
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        for (int i = 0; i < this.designsPerRow * this.designsPerCollum; ++i) {
            int id = i + this.selectedRow * this.designsPerRow;
            if (id < WallpaperDesign.getValuesExceptNone().size()) {
                this.buttons[i].setDesign(WallpaperDesign.getValuesExceptNone().get(id));
                continue;
            }
            this.buttons[i].setDesign(WallpaperDesign.NONE);
        }
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int x, int y, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        int i = this.f_93620_ + 44;
        int j = this.f_93621_;
        if (this.scrollable) {
            this.m_93228_(matrixStack, i, j + this.scrolledY, 232, 0, 12, 15);
        } else {
            this.m_93228_(matrixStack, i, j, 244, 0, 12, 15);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        int i = this.f_93620_ + 44;
        int j = this.f_93621_;
        if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 70)) {
            this.isScrolling = true;
            this.m_7979_(mouseX, mouseY, button, 0.0, 0.0);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling && this.scrollable) {
            double y = mouseY + dragY - (double)this.f_93621_ - 7.5;
            if (y < 0.0) {
                y = 0.0;
            } else if (y > (double)(this.f_93619_ - 15)) {
                y = this.f_93619_ - 15;
            }
            this.scrolledY = (int)Math.round(y);
            this.selectedRow = (int)Math.round(y / (double)(this.f_93619_ - 15) * (double)(this.rowsCount - this.designsPerCollum));
            this.updateButtons();
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.scrollable) {
            while (delta < 0.0 && this.selectedRow < this.rowsCount - this.designsPerCollum) {
                ++this.selectedRow;
                delta += 1.0;
            }
            while (delta > 0.0 && this.selectedRow > 0) {
                --this.selectedRow;
                delta -= 1.0;
            }
            this.scrolledY = (int)Math.round((double)this.selectedRow / (double)(this.rowsCount - this.designsPerCollum) * (double)(this.f_93619_ - 15));
            this.updateButtons();
        }
        return true;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

