/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.setup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import withoutaname.mods.withoutawallpaper.blocks.PastingTableRenderer;
import withoutaname.mods.withoutawallpaper.blocks.PastingTableScreen;
import withoutaname.mods.withoutawallpaper.blocks.WallpaperBakedModel;
import withoutaname.mods.withoutawallpaper.blocks.WallpaperModelLoader;
import withoutaname.mods.withoutawallpaper.setup.Registration;

@Mod.EventBusSubscriber(modid="withoutawallpaper", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void init(@Nonnull FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)Registration.PASTING_TABLE_CONTAINER.get()), PastingTableScreen::new);
        PastingTableRenderer.register();
        event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registration.WALLPAPER_BLOCK.get()), (RenderType)RenderType.m_110466_()));
    }

    @SubscribeEvent
    public static void onModelRegistryEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("withoutawallpaper", "wallpaper_loader"), (IModelLoader)new WallpaperModelLoader());
    }

    @SubscribeEvent
    public static void onTextureStitch(@Nonnull TextureStitchEvent.Pre event) {
        if (event.getMap().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            event.addSprite(PastingTableRenderer.DYES_TEXTURE);
            event.addSprite(WallpaperBakedModel.PARTICLE_TEXTURE);
        }
    }

    public static void registerResourcePack() {
        Minecraft instance = Minecraft.m_91087_();
        if (instance != null) {
            Path packPath = instance.f_91069_.toPath().resolve("config").resolve("withoutawallpaper").resolve("CustomWallpaperResources");
            try {
                ClientSetup.createEmptyPack(packPath);
                PackRepository resourcePackList = Minecraft.m_91087_().m_91099_();
                resourcePackList.addPackFinder((infoConsumer, infoFactory) -> {
                    Pack packInfo = Pack.m_10430_((String)"CustomWallpaperResources", (boolean)true, () -> new FolderPackResources(packPath.toFile()){

                        public boolean isHidden() {
                            return true;
                        }
                    }, (Pack.PackConstructor)infoFactory, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_);
                    if (packInfo != null) {
                        infoConsumer.accept(packInfo);
                    } else {
                        LOGGER.error("Couldn't register resource pack CustomWallpaperResources");
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("Couldn't create resource pack " + packPath.toString(), (Throwable)e);
            }
        }
    }

    private static void createEmptyPack(@Nonnull Path packPath) throws IOException {
        Path packInfoPath;
        Path packAssetsPath = packPath.resolve("assets").resolve("withoutawallpaper").resolve("textures").resolve("block").resolve("wallpaper");
        if (!Files.exists(packAssetsPath, new LinkOption[0])) {
            Files.createDirectories(packAssetsPath, new FileAttribute[0]);
            LOGGER.debug("Created custom wallpaper resource folder: " + packPath.toString());
        }
        if (!Files.exists(packInfoPath = packPath.resolve("pack.mcmeta"), new LinkOption[0])) {
            Files.createFile(packInfoPath, new FileAttribute[0]);
            ArrayList<String> mcMetaFile = new ArrayList<String>();
            mcMetaFile.add("{");
            mcMetaFile.add("    \"pack\": {");
            mcMetaFile.add("        \"description\": \"withoutawallpaper custom wallpaper resources\",");
            mcMetaFile.add("        \"pack_format\": 6");
            mcMetaFile.add("    }");
            mcMetaFile.add("}");
            Files.write(packInfoPath, mcMetaFile, new OpenOption[0]);
            LOGGER.debug("Created pack.mcmeta for custom wallpaper resource pack: " + packInfoPath.toString());
        }
    }
}

