/*
 * Decompiled with CFR 0.152.
 */
package withoutaname.mods.withoutawallpaper.setup;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import withoutaname.mods.withoutawallpaper.tools.WallpaperDesign;

@Mod.EventBusSubscriber
public class Config {
    public static final String CATEGORY_WALLPAPER = "wallpaper";
    public static ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec.BooleanValue ENABLE_CUSTOM_DESIGNS;
    public static List<String> defaultDesigns;
    public static ForgeConfigSpec.ConfigValue<List<String>> CUSTOM_DESIGNS;

    private static void setupServerWallpaperDesignConfig(@Nonnull ForgeConfigSpec.Builder SERVER_BUILDER) {
        ENABLE_CUSTOM_DESIGNS = SERVER_BUILDER.comment("If this is enabled, customDesigns can be edited. [default: false]").define("enableCustomDesigns", false);
        defaultDesigns = new ArrayList<String>();
        defaultDesigns.add("wallpaper0[orange]");
        defaultDesigns.add("wallpaper1[all;all]");
        CUSTOM_DESIGNS = SERVER_BUILDER.comment("Custom designs").define("customDesigns", defaultDesigns);
    }

    private static void loadConfigs() {
        if (!((Boolean)ENABLE_CUSTOM_DESIGNS.get()).booleanValue()) {
            CUSTOM_DESIGNS.set(defaultDesigns);
        }
        WallpaperDesign.loadDesigns();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Config.loadConfigs();
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
        Config.loadConfigs();
    }

    static {
        defaultDesigns = new ArrayList<String>();
        ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
        SERVER_BUILDER.comment("Wallpaper settings").push(CATEGORY_WALLPAPER);
        Config.setupServerWallpaperDesignConfig(SERVER_BUILDER);
        SERVER_BUILDER.pop();
        SERVER_CONFIG = SERVER_BUILDER.build();
    }
}

